﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

using SpaceBuilder.Utils;
using System.Text.RegularExpressions;

namespace SpaceBuilder.MicroBlog.Modules
{
    public class MicroBlogThreadFormatting : IMicroBlogModule
    {
        #region IMicroBlogModule 成员

        public void Init(MicroBlogEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforMicroBlogThreadChange += new MicroBlogThreadEventHandler(em_BeforMicroBlogThreadChange);
        }

        void em_BeforMicroBlogThreadChange(MicroBlogThread thread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                //处理标签
                thread.Body = WebUtils.HtmlEncode(thread.Body);

                //敏感词过滤
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                    thread.Body = Censors.CensorPost(thread.Body);

            }
        }

        #endregion
    }
}
