﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.MicroBlog.Modules
{
    public class ToggleTemporaryAttachmentsForMicroBlog : IMicroBlogModule
    {
        #region IMicroBlogModule 成员

        public void Init(MicroBlogEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterMicroBlogThreadChange += new MicroBlogThreadEventHandler(em_AfterBlogThreadChange);
        }

        void em_AfterBlogThreadChange(MicroBlogThread thread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                //if (SPBConfig.Instance().EnableDistributedStorage)
                //{
                //    SpaceBuilder.MicroBlog.Advanced.WCF.AttachmentManageClient client = new SpaceBuilder.Blog.Advanced.WCF.AttachmentManageClient("BlogToggleTemporaryAttachments");
                //    client.ToggleTemporaryAttachmentsForBlog(blogThread.ThreadID, blogThread.OwnerUserID, null);
                //}
                //else
                //{
                if (thread.HasPhoto)
                    MicroBlogAttachmentManager.Instance().ToggleTemporaryAttachments(thread.ThreadID, thread.OwnerUserID, null);
                //}
            }
        }

        #endregion
    }
}
