﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.MicroBlog;

namespace SpaceBuilder.LuceneSearch
{
    public class MicroBlogSearchTypeSettings : SearchTypeSettingsBase
    {
        /// <summary>
        /// 搜索类型编码
        /// </summary>
        public static readonly string CODE = "012101";

        public override int ApplicationID
        {
            get { return ApplicationIDs.Instance().MicroBlog(); }
        }

        public override string IndexFileDirectory
        {
            get { return MicroBlogSearchManager.Instance().IndexFileDirectory; }
        }

        public override void InitializeIndex(string indexPath)
        {
            MicroBlogSearchManager.Instance().InitializeIndex(indexPath);
        }

        public override bool IsSimulated
        {
            get { return false; }
        }

        public override string SearchAtionUrl
        {
            //todo:增加url
            //get { throw new NotImplementedException(); }
            get { return null; }
        }

        public override string SearchTypeCode
        {
            get { return CODE; }
        }
    }
}
