﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Tasks;
using SpaceBuilder.Common;
using SpaceBuilder.MicroBlog;
using System.Xml.Linq;

namespace SpaceBuilder.LuceneSearch
{
    public class MicroBlogThreadIndexTask : TaskBase
    {
        /// <summary>
        /// 每次更新索引的最大数目
        /// </summary>
        private int count = 1000;

        #region ITask 成员

        public override void ExecuteTask(XElement xElement)
        {
            XAttribute countNode = xElement.Attribute("count");
            if (countNode != null)
            {
                int.TryParse(countNode.Value, out count);
            }
            IndexPosts(count);
        }

        #endregion

        private void IndexPosts(int count)
        {
            SearchDataProvider dp = SearchDataProvider.Instance();
            IList<ItemForIndex> itemsForIndex = dp.GetItemsForIndex(MicroBlogSearchTypeSettings.CODE, count);

            List<ItemForIndex> createItems = new List<ItemForIndex>();
            List<ItemForIndex> updateItems = new List<ItemForIndex>();
            List<ItemForIndex> deleteItems = new List<ItemForIndex>();

            MicroBlogSearchManager searchManager = MicroBlogSearchManager.Instance();
            foreach (ItemForIndex item in itemsForIndex)
            {
                if (item.DataAction == ObjectState.Create)
                    createItems.Add(item);
                else if (item.DataAction == ObjectState.Update)
                    updateItems.Add(item);
                else if (item.DataAction == ObjectState.Delete)
                    deleteItems.Add(item);
            }

            #region Insert

            IList<MicroBlogThread> createPosts = new List<MicroBlogThread>();
            foreach (ItemForIndex item in createItems)
            {
                MicroBlogThread thread = MicroBlogThreads.GetThread(item.ItemID, true);
                if (thread != null)
                    createPosts.Add(thread);
            }

            if (searchManager.Insert(createPosts))
            {
                dp.DeleteItemsForIndex(createItems);
            }
            else
            {
                foreach (ItemForIndex item in createItems)
                {
                    item.DataAction = ObjectState.Update;
                }
                dp.UpdateItemsForIndex(createItems);
            }

            #endregion

            #region Update

            IList<MicroBlogThread> updatePosts = new List<MicroBlogThread>();
            foreach (ItemForIndex item in updateItems)
            {
                MicroBlogThread thread = MicroBlogThreads.GetThread(item.ItemID, true);
                if (thread != null)
                    updatePosts.Add(thread);
            }

            if (searchManager.Update(updatePosts, m => m.Select(n => n.ThreadID).ToList(), MicroBlogIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(updateItems);
            }

            #endregion

            #region Delete
            if (deleteItems.Count > 0 && searchManager.Delete(deleteItems.Select(n => n.ItemID).ToList(), MicroBlogIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(deleteItems);
            }
            #endregion
        }


    }
}
