﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.MicroBlog;
using SpaceBuilder.Common;

namespace SpaceBuilder.LuceneSearch
{
    public class PrepareForMicroBlogThreadIndexModule : IMicroBlogModule
    {

        #region IMicroBlogModule 成员

        public void Init(MicroBlogEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterMicroBlogThreadChange += new MicroBlogThreadEventHandler(em_AfterMicroBlogThreadChange);
        }

        void em_AfterMicroBlogThreadChange(MicroBlogThread thread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if ((thread != null) && (thread.AuditingStatus == AuditingStatuses.Success))
            {
                ItemForIndex item = new ItemForIndex();
                item.ItemID = thread.ThreadID;
                item.SearchTypeCode = MicroBlogSearchTypeSettings.CODE;
                item.DataAction = e.State;
                SearchDataProvider.Instance().CreateUpdateDeleteItemForIndex(item, DataProviderAction.Create);
            }
        }

        #endregion
    }
}
