﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using System.Web;
using SpaceBuilder.Web;
using System.Web.Mvc;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 微博ViewPage基类
    /// </summary>
    public class MicroBlogDomainPublicViewPage : SPBViewPage
    {
        /// <summary>
        /// PresentAreaThemeManager
        /// </summary>
        protected override PresentAreaThemeManager ThemeManager
        {
            get { return MicroBlogPresentAreaThemeManager.Instance(); }
        }

        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {

                Response.Redirect(SiteUrls.Instance().SitePause(), true);
                return;
            }

            base.OnLoad(e);

        }
    }


    /// <summary>
    /// 微博内ViewPage泛型基类
    /// </summary>
    public class MicroBlogDomainPublicViewPage<TModel> : SPBViewPage<TModel> where TModel : class
    {
        /// <summary>
        /// PresentAreaThemeManager
        /// </summary>
        protected override PresentAreaThemeManager ThemeManager
        {
            get { return MicroBlogPresentAreaThemeManager.Instance(); }
        }

        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {
                Response.Redirect(SiteUrls.Instance().SitePause(), true);
                return;
            }

            base.OnLoad(e);
        }
    }
}