﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Web;
using System.Web.Mvc;
using SpaceBuilder.Common;
using SpaceBuilder.MicroBlog;

namespace SpaceBuilder.Web
{

    public class MicroBlogPresentAreaThemeManager : PresentAreaThemeManager
    {
        #region Instance
        private static volatile MicroBlogPresentAreaThemeManager _instance = new MicroBlogPresentAreaThemeManager();
        public static MicroBlogPresentAreaThemeManager Instance()
        {
            return _instance;
        }

        private MicroBlogPresentAreaThemeManager()
        { }
        #endregion

        /// <summary>
        /// 表现区域ID
        /// </summary>
        public override int PresentAreaID
        {
            get { return PresentAreaIDs.Instance().MicroBlogDomain(); }
        }

        /// <summary>
        /// 获取当前表现区域所选中的皮肤名称
        /// </summary>
        public override string GetSelectedThemeName(ControllerContext controllerContext)
        {
            string themeName = null;
            User currentDomainUser = GetCurrentDomainUser(controllerContext);

            if (currentDomainUser == null)
                return PresentArea.DefaultTheme;

            MicroBlogUserData userData = MicroBlogUserDatas.GetUserData(currentDomainUser.UserID, true);
            if (userData == null)
                return PresentArea.DefaultTheme;

            if (PresentArea.EnableThemes)
            {
                Theme theme = Themes.GetTheme(PresentAreaID, userData.Theme, true, false);
                if (theme != null)
                {
                    currentDomainUser = Users.GetUser(currentDomainUser.UserID, HasThemeManagerPermission(currentDomainUser.UserID, Globals.GetCurrentUser()));
                    if (currentDomainUser != null && userData != null)
                    {
                        themeName = userData.Theme;
                    }
                }
            }

            if (string.IsNullOrEmpty(themeName))
                themeName = PresentArea.DefaultTheme;

            return themeName;
        }

        /// <summary>
        /// 获取当前表现区域所选中的外观名称
        /// </summary>
        public override string GetSelectedThemeAppearanceName(ControllerContext controllerContext)
        {
            string themeAppearanceName = null;
            User currentDomainUser = GetCurrentDomainUser(controllerContext);
            if (currentDomainUser == null)
                return PresentArea.DefaultAppearance;

            MicroBlogUserData userData = MicroBlogUserDatas.GetUserData(currentDomainUser.UserID, true);
            if (userData == null)
                return PresentArea.DefaultAppearance;


            if (PresentArea.EnableThemes)
            {
                currentDomainUser = Users.GetUser(currentDomainUser.UserID, HasThemeManagerPermission(currentDomainUser.UserID, Globals.GetCurrentUser()));
                if (currentDomainUser != null)
                {
                    if (!string.IsNullOrEmpty(userData.ThemeAppearance))
                    {
                        ThemeAppearance themeAppearance = Themes.GetThemeAppearance(PresentAreaID, userData.Theme, userData.ThemeAppearance, true, true);
                        if (themeAppearance != null)
                            themeAppearanceName = userData.ThemeAppearance;
                    }
                }
            }

            if (string.IsNullOrEmpty(themeAppearanceName))
                themeAppearanceName = PresentArea.DefaultAppearance;

            return themeAppearanceName;

        }

        /// <summary>
        /// 保存选中的皮肤名和外观名
        /// </summary>
        public override void SavaThemeAndAppearance(ControllerContext controllerContext, string themeName, string themeAppearanceName)
        {
            User currentDomainUser = GetCurrentDomainUser(controllerContext);
            MicroBlogUserData userData = MicroBlogUserDatas.GetUserData(currentDomainUser.UserID, true);
            userData.Theme = themeName;
            userData.ThemeAppearance = themeAppearanceName;
            MicroBlogUserDatas.UpdateThemeAppearance(userData);
        }

        /// <summary>
        /// 验证用户是否对拥有者空间具有管理权限
        /// </summary>
        /// <param name="ownerID">拥有者ID</param>
        /// <param name="User">用户</param>
        public override bool HasThemeManagerPermission(int ownerID, User user)
        {
            if (user == null)
                return false;
            //管理员
            if (user.IsAdministrator || user.IsContentAdministrator)
                return true;

            if (ownerID == user.UserID)
                return true;
            return false;
        }

        private IList<string> layoutModes = null;
        /// <summary>
        /// 版式集合
        /// </summary>
        public override IList<string> LayoutModes
        {
            get
            {
                if (layoutModes == null)
                    layoutModes = new List<string> { "13", "31", "121" };
                return layoutModes;
            }
        }

        /// <summary>
        /// 获取当前空间者
        /// </summary>
        private User GetCurrentDomainUser(ControllerContext controllerContext)
        {
            string userDomainName = controllerContext.GetParameterFromRouteDateOrQueryString("userDomainName");
            User currentDomainUser = Users.GetUser(userDomainName, false);
            //if (currentDomainUser == null)
            //{
            //    throw new Exception(string.Format(ResourceManager.GetString("Exception_Pattern_UserNotFound", Globals.GetCurrentUserLanguage()), userDomainName));
            //}
            return currentDomainUser;
        }

    }
}