﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Common;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// ViewPage基类
    /// </summary>
    public class SPBMobileViewPage : ViewPage
    {
        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {
                Response.Redirect(SiteUrls.Instance().SitePause(), true);
                return;
            }
            else if (!siteSettings.EnableAnonymousBrowse && !Request.IsAuthenticated)
            {
                Response.Redirect(SiteUrls.Instance().Login(true), true);
                return;
            }

            base.OnLoad(e);

            string cssPath = Globals.GetFullUrlInResourceSite("~/Themes/MicroBlogs/Default/Appearances/Default/style.css");
            SpaceBuilder.Web.MobileHeader.AddStyle(cssPath, "screen", StyleRelativePosition.Last);
            //SpaceBuilder.Web.Header.SetLogoUrl("");
        }

        #region  属性

        private User currentUser = null;
        /// <summary>
        /// 当前用户
        /// </summary>
        protected User CurrentUser
        {
            get
            {
                if (currentUser == null)
                    currentUser = Globals.GetCurrentUser();

                return currentUser;
            }
        }

        #endregion
    }

    /// <summary>
    /// ViewPage泛型形式的基类
    /// </summary>
    public class SPBMobileViewPage<TModel> : ViewPage<TModel> where TModel : class
    {
        protected override void OnLoad(EventArgs e)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.IsPause)
            {
                Response.Redirect(SiteUrls.Instance().SitePause(), true);
                return;
            }
            else if (!siteSettings.EnableAnonymousBrowse && !Request.IsAuthenticated)
            {
                Response.Redirect(SiteUrls.Instance().Login(true), true);
                return;
            }

            base.OnLoad(e);

            string cssPath = Globals.GetFullUrlInResourceSite("~/Themes/MicroBlogs/Default/Appearances/Default/style.css");
            SpaceBuilder.Web.MobileHeader.AddStyle(cssPath, "screen", StyleRelativePosition.Last);
            //SpaceBuilder.Web.Header.SetLogoUrl("");
        }

        #region  属性

        private User currentUser = null;
        /// <summary>
        /// 当前用户
        /// </summary>
        protected User CurrentUser
        {
            get
            {
                if (currentUser == null)
                    currentUser = Globals.GetCurrentUser();

                return currentUser;
            }
        }

        #endregion
    }
}
