﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Utils;

using SpaceBuilder.Common;
using SpaceBuilder.Web;
using System.IO;
using SpaceBuilder.Common.Handlers;

namespace SpaceBuilder.News.Handlers
{
    public class NewsPhotoHandler : DownloadFileHandlerBase
    {
        public override void ProcessRequest(HttpContext context)
        {
            //防盗链检测
            if (SPBConfig.Instance().EnableAntiLeech && !Globals.IsAllowableReferrer(context.Request))
            {
                context.Response.Redirect(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/anti-Leech.gif"), true);
                return;
            }

            int attachmentID = context.Request.QueryString.GetInt("AttachmentID", -1);
            if (attachmentID < 0)
            {
                WebUtils.Return404(context);
                return;
            }

            Attachment photo = NewsAttachmentManager.Instance().GetAttachment(attachmentID, true);
            if (photo == null)
            {
                WebUtils.Return404(context);
                return;
            }

            NewsPhotoTypes photoType = NewsPhotoTypes.Title;
            if (!string.IsNullOrEmpty(context.Request.QueryString["PhotoType"]))
            {
                try
                {
                    photoType = (NewsPhotoTypes)Enum.Parse(typeof(NewsPhotoTypes), context.Request.QueryString["PhotoType"], true);
                }
                catch { }
            }

            IFile photoFile = NewsAttachmentManager.Instance().GetResizedPhoto(photo, photoType);
            if (photoFile == null)
            {
                WebUtils.Return404(context);
                return;
            }
            DateTime lastModified = photoFile.LastModified.ToUniversalTime();
            if (IsCacheOK(context, lastModified))
            {
                WebUtils.Return304(context);
                return;
            }
            else
            {
                SetResponsesDetails(context, photo.ContentType, photo.FriendlyFileName, lastModified);

                FileSystemFile fileSystemFile = photoFile as FileSystemFile;
                if (fileSystemFile != null && (!fileSystemFile.FullLocalPath.StartsWith(@"\")))
                {
                    // Send files stored on UNC paths explicitly to avoid a bug with TransmitFile.
                    context.Response.TransmitFile(fileSystemFile.FullLocalPath);
                }
                else
                {
                    context.Response.AddHeader("Content-Length", photoFile.ContentLength.ToString("0"));
                    context.Response.Buffer = false;
                    context.Response.BufferOutput = false;

                    Stream stream = null;
                    try
                    {
                        stream = photoFile.OpenReadStream();
                        if (stream == null)
                        {
                            WebUtils.Return404(context);
                            return;
                        }

                        int bufferLength = photoFile.ContentLength <= DownloadFileHandlerBase.BufferLength ? photoFile.ContentLength : DownloadFileHandlerBase.BufferLength;
                        byte[] buffer = new byte[bufferLength];
                        int readedSize;
                        while ((readedSize = stream.Read(buffer, 0, bufferLength)) > 0)
                        {
                            if (!context.Response.IsClientConnected)
                                break;

                            context.Response.OutputStream.Write(buffer, 0, readedSize);
                            context.Response.OutputStream.Flush();
                        }
                        context.Response.OutputStream.Flush();
                        context.Response.Flush();
                    }
                    catch (Exception ex)
                    {
                        context.Response.Redirect(SiteUrls.Instance().Error(ex.ToString()), true);
                        return;
                    }
                    finally
                    {
                        if (stream != null)
                            stream.Close();
                    }
                }
            }

            context.Response.Cache.VaryByParams["AttachmentID"] = true;
            context.Response.Cache.VaryByParams["PhotoType"] = true;
            context.Response.End();
        }

    }
}
