﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using System.Web.Mvc;
using SpaceBuilder.News;


namespace SpaceBuilder.News.Handlers
{
    class NewsAttachmentsUploadHandler : IHttpHandler
    {
        #region IHttpHandler 成员

        public bool IsReusable
        {
            get { return false; }
        }

        public void ProcessRequest(HttpContext context)
        {
            int currentUserID = int.Parse(EncryptManager.DecryptTokenForInviteFriend(context.Request.Form["currentUserID"]));
            int currentThreadID = Convert.ToInt32(context.Request["associateID"]);

            // 判断用户是否有上传图片的权限
            if (currentUserID < 1)
            {
                WebUtils.Return404(context);
                return;
            }

            User currentUser = Users.GetUser(currentUserID, false);
            if (currentUser == null)
            {
                WebUtils.Return404(context);
                return;
            }

            NewsThread currentThread = null;
            if (currentThreadID > 0)
            {
                currentThread = NewsThreads.GetThread(currentThreadID, false);
                if (currentThread == null)
                {
                    WebUtils.Return404(context);
                    return;
                }
            }

            bool isPermitted = true;
            System.Web.HttpPostedFile postedFile = context.Request.Files["Filedata"];

            if (postedFile.ContentLength > NewsConfiguration.Instance().AttachmentSettings.MaxAttachmentSize * 1024)
            {
                {
                    WebUtils.Return404(context);
                    return;
                }
            }
            if (!currentUser.IsContentAdministrator && context.Request.Files["Filedata"].ContentLength / 1024 > (currentUser.DatabaseQuota - currentUser.DatabaseQuotaUsed))
            {
                context.Response.StatusCode = 200;
                context.Response.Write("{message:'空间容量不足'}");
                context.Response.End();
            }

            if (!string.IsNullOrEmpty(postedFile.FileName))
            {
                string fileTypeString = postedFile.FileName.Substring(postedFile.FileName.LastIndexOf(".") + 1);
                string uploadPhotoTypes = NewsConfiguration.Instance().AttachmentSettings.Extensions;
                string[] types = uploadPhotoTypes.ToLower().Split(new char[] { ',', '，' }, StringSplitOptions.RemoveEmptyEntries);
                isPermitted = types.Contains(fileTypeString.ToLower());
            }
            if (isPermitted)
            {
                Attachment attachment = new Attachment(NewsAttachmentManager.Instance().StorageProviderName, null);
                attachment.UserID = currentUser.UserID;
                attachment.ContentSize = postedFile.ContentLength;
                attachment.ContentType = MimeTypeConfiguration.GetMimeType(postedFile.FileName);
                attachment.DateCreated = DateTime.Now;
                //attachment.FileName = postedFile.FileName;
                attachment.FriendlyFileName = postedFile.FileName;

                if (currentThreadID > 0)
                {
                    attachment.AssociateID = currentThreadID;
                    attachment.OwnerID = currentThread.SectionID;
                    NewsAttachmentManager.Instance().CreateAttachment(attachment, postedFile.InputStream);
                }
                else
                {
                    NewsAttachmentManager.Instance().CreateTemporaryAttachment(attachment, postedFile.InputStream);
                }
            }
            context.Response.StatusCode = 200;
            context.Response.Write("{ok:true}");
            context.Response.End();
        }

        #endregion
    }
}
