//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using SpaceBuilder.Common;
using SpaceBuilder.News;

namespace SpaceBuilder.News.Modules
{
    /// <summary>
    /// ûעᣬԶNews
    /// </summary>
    public class AutoInstallNewsApplication : IGlobalModule
    {
        /// <summary>
        /// ʼ
        /// </summary>
        public void Init(GlobalEventManager pa, System.Xml.Linq.XElement node)
        {
            pa.AfterUserChange += new UserEventHandler(pa_PostUserUpdate);
        }

        private void pa_PostUserUpdate(User user, GlobalEventArgs e)
        {
            if (user != null && e.State == ObjectState.Create)
            {
                if (NewsConfiguration.Instance().EnableAutoCreate)
                {
                    Applications.InstallApplication(user.UserType == UserTypes.PersonUser ? PresentAreaIDs.Instance().UserDomain() : PresentAreaIDs.Instance().CompanyUserDomain(), user.UserID, ApplicationIDs.Instance().News());
                }
            }
        }
    }
}

