﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.News.Modules
{
    /// <summary>
    /// 删除用户时处理资讯
    /// </summary>
    public class DisposeNewsForDeleteUser : IGlobalModule
    {
        #region IGlobalModule 成员

        public void Init(GlobalEventManager gem, System.Xml.Linq.XElement node)
        {
            gem.UserDelete += new UserDeleteEventHandler(gem_UserDelete);
            gem.UserDeleteAndReassignContent += new UserDeleteEventHandler(gem_UserDeleteAndReassignContent);
        }

        void gem_UserDeleteAndReassignContent(User user, string reassignUserName)
        {
            try
            {
                NewsThreads.DeleteUserAndReassignContent(user.UserID, reassignUserName);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error(ResourceManager.GetString("Message_DeleteUserAndMoveNewsError",Globals.GetCurrentUserLanguage(),ApplicationIDs.Instance().News()), e);
            }
        }

        void gem_UserDelete(User user, string reassignUserName)
        {
            try
            {
                if (user.UserType == UserTypes.PersonUser)
                    NewsThreads.DeleteUser(user.UserID);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error(ResourceManager.GetString("Message_DeleteUserNewsError",Globals.GetCurrentUserLanguage(),ApplicationIDs.Instance().News()), e);
            }
        }

        #endregion
    }
}
