﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.News;
using SpaceBuilder.Common.Mail;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;

namespace SpaceBuilder.News.Modules
{
    /// <summary>
    /// 处理与News相关的动态、通知
    /// </summary>
    public class DisposeNoticeForNews : INewsModule
    {
        #region IPostModule 成员
        /// <summary>
        /// 注册相关事件处理程序
        /// </summary>
        public void Init(NewsEventManager nem, System.Xml.Linq.XElement node)
        {
            nem.AfterNewsCommentChange += new NewsCommentEventHandler(nem_AfterNewsCommentChange);
        }

        void nem_AfterNewsCommentChange(NewsComment comment, GlobalEventArgs e)
        {
            if ((e.State == ObjectState.Create))
            {
                NewsThread newsThread = NewsThreads.GetThread(comment.ThreadID, false);
                //通知接收人
                User toUser = null;
                if (comment.ParentID > 0)
                {
                    NewsComment parentComment = NewsComments.GetComment(comment.ParentID, false);
                    if (parentComment != null)
                        toUser = Users.GetUser(parentComment.UserID, false);
                }
                else
                    toUser = Users.GetUser(newsThread.UserID, false);
                if (toUser == null)
                    return;


                if (comment.UserID == newsThread.UserID && comment.ParentID <= 0)
                    return;
                string itemKey = NoticeItemKeys.Instance().NewNewsComment();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;

                NoticeRecord record = new NoticeRecord();
                record.ApplicationID = ApplicationIDs.Instance().News();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.LeadingActorUserID = comment.UserID;
                record.LeadingActor = comment.Author;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().News());
                record.UserID = toUser.UserID;
                record.Receiver = toUser.DisplayName;
                record.RelativeItemID = newsThread.ThreadID;
                record.RelativeItemName = newsThread.Title;
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewNewsComment", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(comment.UserID, comment.Author, true), GetNewsCommentSubjectWithHyperlink(newsThread, comment));
                record.RelativeItemUrl = SiteUrls.Instance().ShowNews(newsThread.ThreadID);
                record.Body = comment.Body;
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        #endregion

        /// <summary>
        /// 获取带链接的博客文章或评论的html代码
        /// </summary>
        private static string GetNewsCommentSubjectWithHyperlink(NewsThread newsThread, NewsComment child)
        {
            if (child != null)
                return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowNews(newsThread.ThreadID, child.CommentID), newsThread.Title);
            else
                return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowNews(newsThread.ThreadID), newsThread.Title);
        }

        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;

    }
}
