﻿using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Common;
using SpaceBuilder.Utils;


namespace SpaceBuilder.News.Modules
{
    public class DisposePointForNews : INewsModule
    {
        #region IPostModule 成员

        public void Init(NewsEventManager nem, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                nem.AfterNewsThreadPointChange += new PointChangeOfNewsThreadHandler(nem_AfterNewsThreadPointChange);
                nem.AfterNewsCommentPointChange += new PointChangeOfNewsCommentHandler(nem_AfterNewsCommentPointChange);
            }
        }

        void nem_AfterNewsCommentPointChange(NewsComment comment, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            User user = Users.GetUser(comment.UserID, false);
            if (user == null)
                return;
            string userPointRecordDescription = string.Empty;
            NewsThread newsThread = NewsThreads.GetThread(comment.ThreadID, false);
            if (userPointDirection == UserPointDirection.Input)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateNewsComment());
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateNewsComment", user.Language, e.ApplicationID), newsThread.Title);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_NewsCommentAuditingSuccess", user.Language, e.ApplicationID), newsThread.Title);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteNewsComment());
                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteNewsComment", user.Language, e.ApplicationID), HtmlUtils.TrimHtml(comment.Body, 128));
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_NewsCommentAuditingFail", user.Language, e.ApplicationID), HtmlUtils.TrimHtml(comment.Body, 128));
            }
            if (role == null)
                return;
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, comment.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

            Points.CreateUserPointRecords(records);
        }

        void nem_AfterNewsThreadPointChange(NewsThread thread, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;
            User user = Users.GetUser(thread.UserID, false);
            if (user == null)
                return;

            if (userPointDirection == UserPointDirection.Input)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().ContributeNewsThread());
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_ContributeNewsThread", user.Language, e.ApplicationID), thread.Title);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_NewsThreadAuditingSuccess", user.Language, e.ApplicationID), thread.Title);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteContributedNewsThread());
                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteContributedNewsThread", user.Language, e.ApplicationID), thread.Title);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_NewsThreadAuditingFail", user.Language, e.ApplicationID), thread.Title);
            }

            if (role == null)
                return;
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, thread.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
            Points.CreateUserPointRecords(records);
        }

        #endregion
    }
}