//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Xml;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;


namespace SpaceBuilder.News.Modules
{
    /// <summary>
    /// ۸ʽ
    /// </summary>
    public class NewsCommentFormatting : INewsModule
    {
        public void Init(NewsEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforNewsCommentChange += new NewsCommentEventHandler(em_BeforNewsCommentChange);
        }

        void em_BeforNewsCommentChange(NewsComment comment, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                comment.Body = Formatter.FormatPlainTextComment(comment.Body);

                if (SPBConfig.Instance().EnableEmoticon)
                    comment.Body = EmotionManager.Instance().EmoticonTransforms(comment.Body);
            }
        }
    }
}
