//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Xml;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using System.Net;
using System.IO;
using System.Text.RegularExpressions;


namespace SpaceBuilder.News.Modules
{
    /// <summary>
    /// Ѷʽ
    /// </summary>
    public class NewsThreadFormatting : INewsModule
    {
        public void Init(NewsEventManager pa, System.Xml.Linq.XElement node)
        {
            pa.BeforNewsThreadChange += new NewsThreadEventHandler(pa_BeforNewsThreadChange);
        }

        void pa_BeforNewsThreadChange(NewsThread thread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                #region 鷢ʱ,ˮ
                if (e.State == ObjectState.Create)
                    Globals.CheckPostDate();
                #endregion

                thread.Title = Formatter.FormatSingleLinePlainTextForStorage(thread.Title);
                thread.Subtitle = Formatter.FormatSingleLinePlainTextForStorage(thread.Subtitle);
                thread.CopyFrom = WebUtils.HtmlEncode(thread.CopyFrom);
                thread.Excerpt = WebUtils.HtmlEncode(thread.Excerpt);
                thread.BodyForDataTransmission = HtmlScrubber.Clean(thread.BodyForDataTransmission, false, true);
                thread.OriginalAuthor = Formatter.FormatSingleLinePlainTextForStorage(thread.OriginalAuthor);


                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    //˵д
                    thread.Title = Censors.CensorPost(thread.Title);
                    thread.CopyFrom = Censors.CensorPost(thread.CopyFrom);
                    thread.Excerpt = Censors.CensorPost(thread.Excerpt);
                    thread.BodyForDataTransmission = Censors.CensorPost(thread.BodyForDataTransmission);
                }

                //ԶͼƬ
                if (thread.IsDownloadRemoteImage)
                    thread.BodyForDataTransmission = ReplaceRemoteUrl(thread.BodyForDataTransmission, thread.ThreadID);
            }
        }

        /// <summary>
        /// 滻ԶͼƬַ
        /// </summary>
        /// <param name="strInput"></param>
        /// <returns>string;滻</returns>
        private string ReplaceRemoteUrl(string body, int threadID)
        {
            //ȡԶͼƬurl
            string pattern = @"(http|https|ftp|rtsp|mms):(\/\/|\\\\){1}((([\w-])+[.]){1,}(net|com|cn|org|cc|tv|[0-9]{1,3}))([^\?\s]*\/)(([^\?\s])+[.]{1}(gif|jpg|jpeg|png|bmp))";

            RegexOptions regexOptions = RegexOptions.Singleline | RegexOptions.IgnoreCase;
            Regex regex = new Regex(pattern, regexOptions);
            MatchCollection matchCollection = regex.Matches(body);
            string newImageUrl = string.Empty;

            if (matchCollection != null && matchCollection.Count > 0)
            {
                foreach (Match match in matchCollection)
                {
                    if (match.Value.Length > 0)
                    {
                        newImageUrl = GetRemoteImage(match.Value, threadID);
                        //سɹ
                        if (!string.IsNullOrEmpty(newImageUrl))
                        {
                            body = body.Replace(match.Value, newImageUrl);
                        }
                    }
                }
            }

            return body;
        }

        /// <summary>
        /// ԶͼƬ
        /// </summary>
        /// <param name="strUrl">ҪصͼƬַ</param>
        /// <returns>string;ͼƬıصַ</returns>
        private string GetRemoteImage(string imageUrl, int threadID)
        {
            WebRequest webRequest = WebRequest.Create(imageUrl);
            HttpWebResponse httpWebResponse = (HttpWebResponse)webRequest.GetResponse();
            Stream stream = httpWebResponse.GetResponseStream();

            bool isImage = httpWebResponse.ContentType.IndexOf("image") > -1;
            if (isImage && stream != null && stream.CanRead)
            {
                MemoryStream memoryStream = new MemoryStream();
                const int bufferLength = 1024;
                int actual;
                byte[] buffer = new byte[bufferLength];

                while ((actual = stream.Read(buffer, 0, bufferLength)) > 0)
                {
                    memoryStream.Write(buffer, 0, actual);
                }

                Attachment attachment = new Attachment(NewsAttachmentManager.Instance().StorageProviderName, null);
                attachment.FriendlyFileName = "a.jpg";
                attachment.UserID = Globals.GetCurrentUser().UserID;
                attachment.ContentType = httpWebResponse.ContentType;
                //Random r = new Random(9999);
                //attachment.FileName = r.Next().ToString() + ".jpg";

                if (threadID > 0)
                {
                    attachment.AssociateID = threadID;
                    NewsAttachmentManager.Instance().CreateAttachment(attachment, memoryStream);
                }
                else
                    NewsAttachmentManager.Instance().CreateTemporaryAttachment(attachment, memoryStream);

                return SiteUrls.Instance().NewsPhotoUrl(attachment.AttachmentID, NewsPhotoTypes.Original);
            }
            else
                return string.Empty;
        }
    }
}
