﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.News.Modules
{
    public class ToggleTemporaryAttachmentsForNews : INewsModule
    {

        #region INewsModule 成员

        public void Init(NewsEventManager em, System.Xml.Linq.XElement element)
        {
            em.AfterNewsThreadChange += new NewsThreadEventHandler(em_AfterNewsThreadChange);
        }

        void em_AfterNewsThreadChange(NewsThread thread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                //将临时附件转为真实附件
                if (SPBConfig.Instance().EnableDistributedStorage)
                {
                    SpaceBuilder.News.Advanced.WCF.AttachmentManageClient client = new SpaceBuilder.News.Advanced.WCF.AttachmentManageClient("NewsToggleTemporaryAttachments");
                    client.ToggleTemporaryAttachmentsForNews(thread.ThreadID, thread.UserID, null);
                }
                else
                {
                    NewsAttachmentManager.Instance().ToggleTemporaryAttachments(thread.ThreadID, thread.UserID, null);
                }
            }
        }


        #endregion
    }
}
