﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.News
{
    /// <summary>
    /// 资讯中使用Cookie
    /// </summary>
    public static class NewsUserCookie
    {
        private static readonly string ReadedNewsThreadIDCookieKey = "ReadedNewsThreadIDs";

        /// <summary>
        /// 保存已读资讯文章ID
        /// </summary>
        public static void SaveReadedNewsThreadIDs(this UserCookie userCookieObject, int newsID)
        {
            if (userCookieObject.Cookie != null)
            {
                string oldNewsIDs = userCookieObject.Cookie[ReadedNewsThreadIDCookieKey];

                userCookieObject.Cookie[ReadedNewsThreadIDCookieKey] = oldNewsIDs + newsID.ToString() + ",";
                userCookieObject.WriteCookie();
            }
        }

        /// <summary>
        /// 获取已读资讯文章ID
        /// </summary>
        /// <returns>
        /// 例如：1,2,6,
        /// </returns>
        public static string GetReadedNewsThreadIDs(this UserCookie userCookieObject)
        {
            if (userCookieObject.Cookie != null)
                return userCookieObject.Cookie[ReadedNewsThreadIDCookieKey];
            else
                return null;
        }
    }
}
