﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.News
{
    /// <summary>
    /// 资讯全文检索查询类
    /// </summary>
    public class NewsThreadFullTextQuery
    {
        /// <summary>
        /// SectionID
        /// </summary>
        public int SectionID = -1;

        /// <summary>
        /// 是否包含SectionID的子孙类别
        /// </summary>
        public bool IncludeSectionDescendant = true;

        /// <summary>
        /// UserID
        /// </summary>
        public int UserID = -1;

        /// <summary>
        /// 标题前缀
        /// </summary>
        public int PrefixID = -1;

        /// <summary>
        /// 关键字
        /// </summary>
        public string Keyword = string.Empty;

        /// <summary>
        /// 标签
        /// </summary>
        public string TagName = null;

        /// <summary>
        /// 作者
        /// </summary>
        public string Author = string.Empty;

        /// <summary>
        /// 排序字段
        /// </summary>
        public FullTextQueryNewsSortBy SortBy = FullTextQueryNewsSortBy.Relevance;

        /// <summary>
        /// 当前显示页面页码
        /// </summary>
        private int pageIndex = 1;
        public int PageIndex
        {
            get
            {
                if (pageIndex < 1)
                    return 1;
                else
                    return pageIndex;
            }
            set { pageIndex = value; }
        }

        /// <summary>
        /// 每页显示记录数
        /// </summary>
        public int PageSize = 20;

        /// <summary>
        /// 查询条件是否有效
        /// </summary>
        public bool IsValid()
        {
            if (UserID > 0 || SectionID > 0 || !string.IsNullOrEmpty(Keyword) || !string.IsNullOrEmpty(Author) || !string.IsNullOrEmpty(TagName))
                return true;
            else
                return false;
        }


        /// <summary>
        /// 从QueryString获取查询条件
        /// </summary>
        public void ConvertFromQueryString(System.Web.HttpRequestBase request)
        {
            if (!string.IsNullOrEmpty(request.QueryString["SectionID"]))
                int.TryParse(request.QueryString["SectionID"], out this.SectionID);

            if (!string.IsNullOrEmpty(request.QueryString["IncludeSectionDescendant"]))
                bool.TryParse(request.QueryString["IncludeSectionDescendant"], out this.IncludeSectionDescendant);

            if (!string.IsNullOrEmpty(request.QueryString["UserID"]))
                int.TryParse(request.QueryString["UserID"], out this.UserID);

            if (!string.IsNullOrEmpty(request.QueryString["PrefixID"]))
                int.TryParse(request.QueryString["PrefixID"], out this.PrefixID);

            if (!string.IsNullOrEmpty(request.QueryString["Keyword"]))
                this.Keyword = request.QueryString["Keyword"];

            if (!string.IsNullOrEmpty(request.QueryString["TagName"]))
                this.TagName = request.QueryString["TagName"];

            if (!string.IsNullOrEmpty(request.QueryString["Author"]))
                this.Author = request.QueryString["Author"];

            if (!string.IsNullOrEmpty(request.QueryString["SortBy"]))
            {
                int sortByValue;
                int.TryParse(request.QueryString["SortBy"], out sortByValue);
                this.SortBy = (FullTextQueryNewsSortBy)sortByValue;
            }

            if (!string.IsNullOrEmpty(request.QueryString["PaseSize"]))
                int.TryParse(request.QueryString["PaseSize"], out this.PageSize);
        }


    }


    /// <summary>
    /// 资讯全文检索排序字段
    /// </summary>
    public enum FullTextQueryNewsSortBy
    {
        /// <summary>
        /// 相关性
        /// </summary>
        /// <remarks>
        /// 全文索引库默认排序方式
        /// </remarks>
        Relevance = 0,

        /// <summary>
        /// 创建日期
        /// </summary>
        DateCreated = 1
    }

}