﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.News;
using SpaceBuilder.Common;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// 处理Bookmark的变更，把变更情况记录到数据库，并在<see cref="SpaceBuilder.LuceneSearch.NewsThreadIndexTask"/>批量更新到Lucene索引文件中
    /// </summary>
    public class PrepareForNewsThreadIndexModule : INewsModule
    {
        #region INewsModule 成员

        public void Init(NewsEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterNewsThreadChange += new NewsThreadEventHandler(em_AfterNewsThreadChange);
        }

        void em_AfterNewsThreadChange(NewsThread thread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if ((thread != null) && (e.State == ObjectState.Create || e.State == ObjectState.Update || e.State == ObjectState.Delete))
            {
                ItemForIndex item = new ItemForIndex();
                item.ItemID = thread.ThreadID;
                item.SearchTypeCode = NewsSearchTypeSettings.CODE;
                item.DataAction = e.State;

                SearchDataProvider.Instance().CreateUpdateDeleteItemForIndex(item, DataProviderAction.Create);
            }
        }

        #endregion
    }
}
