﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.News
{
    public static class SiteUrlsExtensions
    {
        #region News

        /// <summary>
        /// 资讯频道详细页
        /// </summary>
        public static string ShowNews(this SiteUrls siteUrls, int threadID)
        {
            return SPBUrlHelper.RouteUrl("Channel_News_ShowNews", new RouteValueDictionary { { "newsID", threadID } });
        }
        /// <summary>
        /// 资讯频道详细页
        /// </summary>
        public static string ShowNews(this SiteUrls siteUrls, int threadID, int commentID)
        {
            return ShowNews(siteUrls, threadID) + "#" + commentID;
        }

        public static string ListNewsForTag(this SiteUrls siteUrls, string tagName)
        {
            return SPBUrlHelper.Action("ListNewsForTag", "ChannelNews", new RouteValueDictionary { { "tagName", WebUtils.UrlEncode(tagName) } });
        }

        /// <summary>
        /// 资讯频道首页
        /// </summary>
        public static string ChannelNewsHome(this SiteUrls siteUrls)
        {
            return SPBUrlHelper.RouteUrl("Channel_News_Home");
        }

        public static string ChannelNewsListNews(this SiteUrls siteUrls, int sectionID)
        {
            return SPBUrlHelper.RouteUrl("Channel_News_ShowSection", new RouteValueDictionary { { "sectionID", sectionID } });
        }

        /// <summary>
        /// 下载或查看附件
        /// </summary>
        public static string DownloadNewsAttachment(this SiteUrls siteUrls, int attachmentID)
        {
            return Globals.GetFullUrlInFileHandlerSite(NewsAttachmentManager.Instance().StorageProviderName, string.Format("~/Services/NewsAttachment.ashx?AttachmentID={0}", attachmentID));
        }

        /// <summary>
        /// 删除资讯附件Url
        /// </summary>
        public static string DeleteNewsAttachmentUrl(this SiteUrls siteUrls, int attachmentID, bool? isImage)
        {
            User currentUser = Globals.GetCurrentUser();
            if (currentUser == null)
                return string.Empty;

            return SPBUrlHelper.RouteUrl("Common", new RouteValueDictionary { { "controller", "ChannelNews" }, { "action", "DeleteNewsAttachment" }, { "userDomainName", currentUser.UserName }, { "attachmentID", attachmentID }, { "isImage", isImage } });
        }

        /// <summary>
        /// 根据AttachmentID获取标题图片Url
        /// </summary>
        public static string NewsPhotoUrl(this SiteUrls siteUrls, int attachmentID, NewsPhotoTypes photoType)
        {
            if (FileStorageProvider.Instance(NewsAttachmentManager.Instance().StorageProviderName).EnableDirectlyUrl)
            {
                Attachment photo = NewsAttachmentManager.Instance().GetAttachment(attachmentID, false);
                if (photo == null)
                    return string.Empty;

                //默认仅预生成标题图
                if (photoType == NewsPhotoTypes.Original || photoType == NewsPhotoTypes.Title)
                    return NewsAttachmentManager.Instance().GetDirectlyUrl(photo, photoType);
            }

            return Globals.GetFullUrlInFileHandlerSite(NewsAttachmentManager.Instance().StorageProviderName, string.Format("~/Services/News/NewsPhoto.ashx?AttachmentID={0}&PhotoType={1}", attachmentID, photoType));
        }

        #endregion
    }
}
