﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common.Controllers;
using SpaceBuilder.Web;
using SpaceBuilder.Common;

using System.Web.Routing;
using SpaceBuilder.Photo;
using System.Web.Mvc;

namespace SpaceBuilder.Photo.Controllers
{
    [ManageAuthorize]
    [HttpCompress]
    public class ManagePhotoController : ManageControllerBase
    {
        #region 照片管理

        /// <summary>
        /// 置顶使用
        /// </summary>
        private int topSpecialOrder = 1;
        private int applicationID = ApplicationIDs.Instance().Photo();
        /// <summary>
        /// 照片列表页
        /// </summary>
        /// <param name="status"></param>
        /// <returns></returns>
        public ActionResult ManageThreads(AuditingStatusesForDisplay? status)
        {
            SetPageTitle(GetResourceString("Title_ManagerCallery", applicationID));
            ViewData["status"] = AuditingStatusesForDisplay.Pending;
            if (status.HasValue)
                ViewData["status"] = (AuditingStatusesForDisplay)status;
            int intStatus = Request.QueryString.GetInt("status", -1);
            if (intStatus > 0)
                ViewData["status"] = (AuditingStatusesForDisplay)intStatus;

            return View("Pages/Photos/ManageThreads.aspx", "Masters/Photo.master");
        }

        /// <summary>
        /// 照片列表控件
        /// </summary>
        public ActionResult Control_ListThreads(AuditingStatusesForDisplay? status, int? pageIndex)
        {
            int PageSize = 17;
            if (!pageIndex.HasValue)
                pageIndex = 1;
            int ownerUserID = Request.QueryString.GetInt("CommentUserID", -1);
            string subjectkeyWords = Request.QueryString.GetString("CommentKeyWords", string.Empty).Trim();

            if (!status.HasValue)
                status = AuditingStatusesForDisplay.Pending;



            PagingDataSet<PhotoThread> pds = PhotoThreads.GetThreadsForAdmin(PageSize, pageIndex.Value, status, ownerUserID, subjectkeyWords);
            return PartialView("Controls/Photos/ListThreads.ascx", pds);
        }

        /// <summary>
        /// 删除单个图片
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult DeleteThread(AuditingStatusesForDisplay? status, int? pageIndex)
        {
            int threadID = Request.QueryString.GetInt("threadID", -1);
            if (threadID < 0)
                throw new ArgumentException(string.Format(GetResourceString("Exception_Pattern_NotHaveImage", applicationID), threadID));
            PhotoThread ph = PhotoThreads.GetThread(threadID, null, true);
            if (ph == null)
                throw new ArgumentException(string.Format(GetResourceString("Exception_Pattern_NotHaveImage", applicationID), threadID));
            PhotoThreads.DeleteThread(ph);

            return Redirect(Request.UrlReferrer.ToString());
        }

        /// <summary>
        /// 批量删除图片
        /// </summary>
        /// <param name="returnUrl">返回的url</param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult DeleteThreads(string returnUrl)
        {
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        if (int.TryParse(Id, out threadID))
                        {
                            if (threadID > 0)
                            {
                                PhotoThread ph = PhotoThreads.GetThread(threadID, null, true);
                                PhotoThreads.DeleteThread(ph);
                            }

                        }

                    }
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_DeleteSelectInageSuccess", applicationID);
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_SelectDeleteGallery", applicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 批量更新图片状态
        /// </summary>
        /// <param name="returnUrl">返回url</param>
        /// <param name="auditingStatus">AuditingStatuses枚举</param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateThreadAuditingStatus(string returnUrl, AuditingStatuses auditingStatus)
        {
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }

                    PhotoThreads.UpdateAuditingStatus(ListThreadID, auditingStatus);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_ImageSelectSetSuccess", applicationID);

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_PlaseSelectSetImage", applicationID);
            }
            return Redirect(returnUrl);
        }


        /// <summary>
        /// 设置为精华
        /// </summary>
        public ActionResult SetEssential(string returnUrl)
        {
            if (!CurrentUser.IsContentAdministrator)
            {
                throw new ArgumentException(GetResourceString("Exception_AdminSetHighLimit", applicationID));
            }
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }


                    PhotoThreads.SetEssential(ListThreadID, true);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_CalleryImageAllSetSuccess", applicationID);

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_PlaseSelectSetImage", applicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 取消精华设置
        /// </summary>
        public ActionResult CancelEssential(string returnUrl)
        {

            if (!CurrentUser.IsContentAdministrator)
            {
                throw new ArgumentException(GetResourceString("Meessage_OnlyAdminCanCancleLimit", applicationID));
            }
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }

                    PhotoThreads.SetEssential(ListThreadID, false);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_CalleryImageAllCancleSuccess", applicationID);
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_PlaseSelectSetImage", applicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 设为置顶
        /// </summary>
        public ActionResult SetTop(string returnUrl)
        {
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }


                    PhotoThreads.SetSticky(ListThreadID, topSpecialOrder);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_CalleryImageSetFirstSucecss", applicationID);

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_PlaseSelectSetImage", applicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 取消置顶
        /// </summary>
        public ActionResult CancelTop(string returnUrl)
        {
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }


                    PhotoThreads.SetSticky(ListThreadID, 0);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_CalleryImageCancleFirstSucecss", applicationID);

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_PlaseSelectSetImage", applicationID);
            }
            return Redirect(returnUrl);
        }

        #endregion

        #region 照片评论管理

        /// <summary>
        ///获取图片评论列表页面
        /// </summary>
        /// <param name="Statuses">分类 如：已通过审核</param>
        /// <param name="pageIndex">页码</param>
        /// <returns></returns>
        public ActionResult ManageComments(AuditingStatusesForDisplay? status, int? pageIndex)
        {
            SetPageTitle(GetResourceString("Title_ManagerCallery", applicationID));
            ViewData["status"] = AuditingStatusesForDisplay.Pending;
            if (status.HasValue)
                ViewData["status"] = (AuditingStatusesForDisplay)status;
            int intStatus = Request.QueryString.GetInt("status", -1);
            if (intStatus > 0)
                ViewData["status"] = (AuditingStatusesForDisplay)intStatus;

            return View("Pages/Photos/ManageComments.aspx", "Masters/Photo.master");
        }
        /// <summary>
        /// 获取图片的评论列表控件
        /// </summary>
        /// <param name="Statuses">分类 如：已通过审核</param>
        /// <param name="pageIndex">页码</param>
        /// <returns></returns>
        public ActionResult Control_ListComments(AuditingStatusesForDisplay? status, int? pageIndex)
        {
            int PageSize = 17;
            if (!pageIndex.HasValue)
                pageIndex = 1;
            if (!status.HasValue)
                status = AuditingStatusesForDisplay.Success;
            int ownerUserID = Request.QueryString.GetInt("CommentUserID", -1);
            string bodyKeywords = Request.QueryString.GetString("CommentKeyWords", string.Empty).Trim();

            PagingDataSet<PhotoComment> pds = PhotoComments.GetCommentsForAdmin(PageSize, pageIndex.Value, status, ownerUserID, bodyKeywords);
            return PartialView("Controls/Photos/ListComments.ascx", pds);
        }

        /// <summary>
        /// 批量更新图片评论的状态
        /// </summary>
        /// <param name="returnUrl">返回的地址</param>
        /// <param name="auditingStatus">状态 AuditingStatuses 枚举</param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateCommentAuditingStatus(string returnUrl, AuditingStatuses auditingStatus)
        {
            string selectedPostIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedPostIDsString))
            {
                string[] selectedPostIDsStringArray = selectedPostIDsString.Split(',');
                if (selectedPostIDsStringArray != null && selectedPostIDsStringArray.Length > 0)
                {
                    int postID;
                    List<int> ListPostID = new List<int>();
                    string[] ids;
                    foreach (string Id in selectedPostIDsStringArray)
                    {
                        try
                        {
                            ids = Id.Split(':');
                            postID = int.Parse(ids[0]);
                            ListPostID.Add(postID);
                        }
                        catch { }
                    }


                    PhotoComments.UpdateAuditingStatus(ListPostID, auditingStatus);
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_ImageLeaveWordAllSetSucecss", applicationID);
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_PlaseSelectSetImageLeaveWord", applicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        ///批量删除图片评论 
        /// </summary>
        /// <param name="returnUrl">返回的url</param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult DeleteComments(string returnUrl)
        {
            string selectedPostIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedPostIDsString))
            {
                string[] selectedPostIDsStringArray = selectedPostIDsString.Split(',');
                if (selectedPostIDsStringArray != null && selectedPostIDsStringArray.Length > 0)
                {
                    string[] IDs;
                    int postID;
                    int ownerID;
                    foreach (string postownerIDs in selectedPostIDsStringArray)
                    {
                        IDs = postownerIDs.Split(':');

                        if (int.TryParse(IDs[0], out postID) && int.TryParse(IDs[1], out ownerID))
                            if (postID > 0 && ownerID > 0)
                                PhotoComments.Delete(postID);

                    }
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_DeleteSelectImageLeaveWordSuccess", applicationID);
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_PlaseSelectDeleteImageLeaveWord", applicationID);
            }
            return Redirect(returnUrl);
        }

        #endregion

        #region 相册站点类别
        /// <summary>
        /// 站点类别
        /// </summary>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ManageSiteCategories()
        {
            SetPageTitle(GetResourceString("Title_ManagerCallery", applicationID));
            ViewData["SiteCategoryDepth"] = PhotoConfiguration.Instance().SiteCategoryLevel - 1;
            return View("Pages/Photos/ManageSiteCategories.aspx", "Masters/Photo.master");
        }

        /// <summary>
        /// 设置站点类别
        /// </summary>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Control_SetSiteCategories()
        {
            string selectedThreadIDsString = Request["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                ViewData["ListThreadID"] = selectedThreadIDsString;
            }
            else
            {
                ViewData["StatusMessageType"] = (int)StatusMessageType.Error;
                ViewData["StatusMessageContent"] = GetResourceString("Message_PlaseSelectSetImage", applicationID);
                return PartialView("Controls/Photos/SetSiteCategories.ascx");
            }

            List<SiteCategory> allCategories = SiteCategories.Instance(ApplicationIDs.Instance().Photo()).GetAll(true);
            return PartialView("Controls/Photos/SetSiteCategories.ascx", allCategories);
        }

        /// <summary>
        /// 更新站点类别
        /// </summary>
        /// <param name="selectedThreadIDsString"></param>
        /// <returns></returns>
        public ActionResult Control_UpdateSiteCategories(string selectedThreadIDsString)
        {
            string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
            if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
            {
                int threadID;
                List<int> ListThreadID = new List<int>();
                foreach (string Id in selectedThreadIDsStringArray)
                {
                    try
                    {
                        threadID = int.Parse(Id);
                        ListThreadID.Add(threadID);
                    }
                    catch { }
                }
                int CategoryID = Request.Form.GetInt("toCategoryID", -1);
                if (CategoryID > 0)
                {
                    PhotoThreads.UpdateSiteCategory(ListThreadID, CategoryID);
                    ViewData["StatusMessageType"] = (int)StatusMessageType.Success;
                    ViewData["StatusMessageContent"] = GetResourceString("Message_ImageSetCategorySucecss", applicationID);
                }
                else
                {
                    ViewData["StatusMessageType"] = (int)StatusMessageType.Hint;
                    ViewData["StatusMessageContent"] = GetResourceString("Message_PlaseSelectPointCategry", applicationID);
                }

            }
            ViewData["ListThreadID"] = selectedThreadIDsString;
            List<SiteCategory> allCategories = SiteCategories.Instance(ApplicationIDs.Instance().Photo()).GetAll(true);
            return PartialView("Controls/Photos/SetSiteCategories.ascx", allCategories);
        }

        #endregion

        #region 相册管理
        public ActionResult ManageGallery(int? pageIndex)
        {
            SetPageTitle(GetResourceString("Title_ManagerCallery", applicationID));
            int PageSize = 17;
            int userID = Request.QueryString.GetInt("UserID", -1);
            string bodyKeyWords = Request.QueryString.GetString("KeyWords", string.Empty).Trim();
            PagingDataSet<UserCategory> pds = UserCategoryManager.Instance(UserCategoryItemKeys.Instance().Photo()).GetUserCategoriesForAdmin(PageSize, pageIndex ?? 1, userID, bodyKeyWords);
            return View("Pages/Photos/ManageGallery.aspx", "Masters/Photo.master", pds);
        }

        public ActionResult DeleteGallery(int? pageIndex)
        {
            int categoryID = Request.QueryString.GetInt("categoryID", -1);
            int userID = Request.QueryString.GetInt("userID", -1);
            UserCategoryManager.Instance(UserCategoryItemKeys.Instance().Photo()).DeleteUserCategory(categoryID, userID);
            return Redirect(Request.UrlReferrer.ToString());
        }


        public ActionResult DeleteGallerys(string returnUrl)
        {
            string selectedGalleryIDs = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedGalleryIDs))
            {
                string[] selectedGalleryIDsArray = selectedGalleryIDs.Split(',');
                if (selectedGalleryIDsArray.Length > 0 && selectedGalleryIDsArray != null)
                {
                    foreach (string id in selectedGalleryIDsArray)
                    {
                        string[] selectedArray = id.Split(';');
                        int categoryID, userID;
                        if (int.TryParse(selectedArray[0], out userID) && int.TryParse(selectedArray[1], out categoryID))
                        {
                            if (categoryID > 0 && userID > 0)
                            {
                                UserCategoryManager.Instance(UserCategoryItemKeys.Instance().Photo()).DeleteUserCategory(categoryID, userID);
                            }
                        }

                    }
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_DeleteSelectGallerySuccess", applicationID);
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_SelectDeleteGallery", applicationID);
            }
            return Redirect(returnUrl);

        }

        #endregion

        /// <summary>
        /// 获取相册数据统计
        /// </summary>
        /// <returns></returns>
        public JsonResult GetManageableCounts()
        {
            Dictionary<PhotoManageableCounts, int> dictionary = PhotoThreads.GetManageableCounts();
            Application photoApplication = Applications.GetApplication(ApplicationIDs.Instance().Photo());
            List<ManageableCount> list = new List<ManageableCount>();
            list.Add(new ManageableCount { Name = "新增照片", Value = photoApplication.CountInPast24Hours });
            if (dictionary.ContainsKey(PhotoManageableCounts.PendingThreadCount))
                list.Add(new ManageableCount { Name = "待审核照片", Value = dictionary[PhotoManageableCounts.PendingThreadCount], Url = SPBUrlHelper.Action("ManageThreads", "ManagePhoto", new RouteValueDictionary{ {"status", AuditingStatusesForDisplay.Pending}}) });
            if (dictionary.ContainsKey(PhotoManageableCounts.AgainThreadCount))
                list.Add(new ManageableCount { Name = "需再审核照片", Value = dictionary[PhotoManageableCounts.AgainThreadCount], Url = SPBUrlHelper.Action("ManageThreads", "ManagePhoto", new RouteValueDictionary { { "status", AuditingStatusesForDisplay.Again } }) });
            if (dictionary.ContainsKey(PhotoManageableCounts.PendingCommentCount))
                list.Add(new ManageableCount { Name = "待审核评论", Value = dictionary[PhotoManageableCounts.PendingCommentCount], Url = SPBUrlHelper.Action("ManageComments", "ManagePhoto", new RouteValueDictionary { { "status", AuditingStatusesForDisplay.Pending } }) });
            list.Add(new ManageableCount { Name = "总照片数", Value = photoApplication.TotalCount });
            return Json(list,JsonRequestBehavior.AllowGet);
        }

        #region 标签管理
        /// <summary>
        /// 标签管理
        /// </summary>
        /// <returns></returns>
        public ActionResult ManageSiteTags()
        {
            return View("Pages/Photos/ManageSiteTags.aspx", "Masters/Photo.master");
        }
        #endregion
    }

    #region PhotoSubMenu
    public enum PhotoSubMenu
    {
        /// <summary>
        /// 图片管理
        /// </summary>
        ManagePhotos = 2501,

        /// <summary>
        /// 图片评论管理
        /// </summary>
        ManagePhotoComments = 2506,

        /// <summary>
        /// 站点类别
        /// </summary>
        ManagePhotoSiteCategories = 2509,
        /// <summary>
        /// 相册管理
        /// </summary>
        ManageGallerys = 2504,
        /// <summary>
        /// 标签管理
        /// </summary>
        ManageSiteTags = 2507,
    }
    #endregion
}
