﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Photo;
using SpaceBuilder.Common.Handlers;
using SpaceBuilder.Web;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using SpaceBuilder.Rss;

namespace SpaceBuilder.Photo.Handlers
{
    /// <summary>
    /// 用于生成图片rss
    /// </summary>
    public class RssPhotoHandler : BaseRssHandler
    {
        private User galleryOwner = null;
        /// <summary>
        /// 相册主人
        /// </summary>
        public User GalleryOwner
        {
            get { return galleryOwner; }
            set { galleryOwner = value; }
        }

        private int categoryID = -1;
        public int CategoryID
        {
            get { return categoryID; }
            set { categoryID = value; }
        }

        private string tagName = null;
        public string TagName
        {
            get { return tagName; }
            set { tagName = value; }
        }

        private PhotoSection currentPhotoSectioin = null;
        public PhotoSection CurrentPhotoSectioin
        {
            get
            {
                if (currentPhotoSectioin == null)
                {
                    if (GalleryOwner != null)
                        currentPhotoSectioin = PhotoSections.Get(GalleryOwner.UserID, false);
                }

                return currentPhotoSectioin;
            }
        }

        /// <summary>
        /// Appends http://Host:Port to all blog urls
        /// </summary>
        protected override string BaseUrl
        {
            get { return WebUtils.HostPath(Context.Request.Url); }
        }

        protected override int CacheTime { get { return PhotoConfiguration.Instance().RssCacheWindowInSeconds; } }

        protected override string CacheKey
        {
            get
            {
                if (!string.IsNullOrEmpty(TagName))
                    return string.Format("Rss_Pictures:{0}:TagName:{1}", GalleryOwner.UserID, TagName);
                else if (this.CategoryID > 0)
                    return string.Format("Rss_Pictures:{0}:CategoryID:{1}", GalleryOwner.UserID, this.CategoryID);
                else
                    return string.Format("Rss_Pictures:{0}:Individual", GalleryOwner.UserID);
            }
        }

        protected override void ProcessFeed()
        {
            int ownerUserID = this.Context.Request.QueryString.GetInt("OwnerUserID", 0);
            if (ownerUserID > 0)
            {
                GalleryOwner = Users.GetUser(ownerUserID, false);
            }

            if (GalleryOwner == null)
            {
                GalleryOwner = Users.GetUser(this.Context.Request.QueryString["UserDomainName"], false);
            }

            this.categoryID = this.Context.Request.QueryString.GetInt("CategoryID", 0);

            this.TagName = this.Context.Request.QueryString["TagName"];

            base.ProcessFeed();
        }

        protected override CachedFeed BuildFeed()
        {
            if (CurrentPhotoSectioin == null)
                return new CachedFeed(DateTime.Now, null, string.Empty);

            RssDocument rssDoc = new RssDocument();
            rssDoc.UseExternalNamespaces = true;
            //if (!string.IsNullOrEmpty(StyleSheet))
            //    rssDoc.StyleSheet = FormatUrl(WebUtils.ResolveUrl(StyleSheet));

            RssChannel rssChannel = new RssChannel();
            rssChannel.Title = CurrentPhotoSectioin.SectionName;
            rssChannel.Link = FormatUrl(SiteUrls.Instance().UserChannelHome(GalleryOwner, ApplicationIDs.Instance().Photo()));
            rssChannel.Description = CurrentPhotoSectioin.Description;
            //rssChannel.Language = currentGallery.Langugage;
            rssChannel.Generator = SPBConfig.Instance().SpaceBuilderVersionInfo;

            PagingDataSet<PhotoThread> pds = PhotoThreads.GetThumbnailThreads(currentPhotoSectioin.OwnerUserID, this.tagName, this.categoryID, 1);

            List<RssItem> rssItems = new List<RssItem>();

            foreach (PhotoThread photo in pds.Records)
            {
                RssItem item = new RssItem();
                item.Title = WebUtils.HtmlDecode(photo.Subject);
                item.Link = FormatUrl(SiteUrls.Instance().ShowPicture(GalleryOwner.UserName, photo.ThreadID));
                item.Author = photo.Author;
                item.PubDate = photo.PostDate;

                RssGuid guid = new RssGuid();
                guid.IsPermaLink = false;
                guid.Text = SiteSettingsManager.GetSiteSettings().SiteKey + ":photo:" + photo.ThreadID;
                item.Guid = guid;

                item.Comments = item.Link;
                item.Description = string.Format("<div><a href='{0}'><img src='{1}' alt='{2}' border='0'/></a></div>{3}", FormatUrl(SiteUrls.Instance().ShowPicture(GalleryOwner.UserName, photo.ThreadID)), FormatUrl(SiteUrls.Instance().PictureUrl(photo.ThreadID, PhotoImageType.SecondaryThumbnail)), WebUtils.HtmlDecode(photo.Subject), photo.GetBody());

                //启用rss阅读计数
                item.Description = string.Format("{0}<img src=\"{1}\" width=\"1\" height=\"1\">", item.Description, FormatUrl(SiteUrls.Instance().AggView(typeof(PhotoCounter), photo.ThreadID)));

                item.ReplyCount = photo.CommentCount;

                rssItems.Add(item);
            }

            rssDoc.Channel = rssChannel;
            rssChannel.Items = rssItems;

            DateTime dt = pds.Records.Count > 0 ? pds.Records[0].PostDate : DateTime.Now;

            return new CachedFeed(dt, null, rssDoc.ToXml());
        }


    }
}
