﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;


namespace SpaceBuilder.Photo.Handlers
{
    class UploadPhotosHandler : IHttpHandler
    {
        #region IHttpHandler 成员

        public bool IsReusable
        {
            get { return false; }
        }

        public void ProcessRequest(HttpContext context)
        {
            int currentUserID = int.Parse(EncryptManager.DecryptTokenForInviteFriend(context.Request.Form["currentUserID"]));

            // 判断用户是否有上传图片的权限
            User currentUser = Users.GetUser(currentUserID, false);

            if (!(currentUser.IsContentAdministrator || (currentUser.UserID == Convert.ToInt32(context.Request["associateID"]))))
            {
                WebUtils.Return404(context);
                return;
            }

            bool isPermitted = true;

            if (context.Request.Files["Filedata"].ContentLength > PhotoAttachmentManager.Instance().Settings.MaxAttachmentSize * 1024)
            {
                WebUtils.Return404(context);
                return;
            }
            //if (!currentUser.IsContentAdministrator && context.Request.Files["Filedata"].ContentLength / 1024 > (currentUser.DatabaseQuota - currentUser.DatabaseQuotaUsed))
            //{
            //    WebUtils.Return404(context);
            //    return;
            //}

            if (!currentUser.IsContentAdministrator && context.Request.Files["Filedata"].ContentLength / 1024 > (currentUser.DatabaseQuota - currentUser.DatabaseQuotaUsed))
            {
                context.Response.StatusCode = 200;
                context.Response.Write("{message:'空间容量不足'}");
                context.Response.End();
            }

            if (!string.IsNullOrEmpty(context.Request.Files["Filedata"].FileName))
            {
                string fileTypeString = context.Request.Files["Filedata"].FileName.Substring(context.Request.Files["Filedata"].FileName.LastIndexOf(".") + 1);
                string uploadPhotoTypes = PhotoAttachmentManager.Instance().Settings.Extensions;
                string[] types = uploadPhotoTypes.ToLower().Split(new char[] { ',', '，' }, StringSplitOptions.RemoveEmptyEntries);
                isPermitted = types.Contains(fileTypeString.ToLower());
            }
            if (isPermitted)
            {
                PhotoThread photo = new PhotoThread();
                photo.OwnerUserID = Convert.ToInt32(context.Request["associateID"]);
                User owner = Users.GetUser(photo.OwnerUserID, false);

                if (owner != null)
                {
                    photo.Author = owner.DisplayName;
                    //photo.SiteCategoryID = Convert.ToInt32(context.Request["photoSiteCategoryDDL"]);
                    if (context.Request["photoUserCategoryDDL"] != null)
                        photo.UserCategoryID = Convert.ToInt32(context.Request["photoUserCategoryDDL"]);


                    //if (!string.IsNullOrEmpty(Convert.ToString(context.Request["userTags"])))
                    //{
                    //    string[] tagNames = (Convert.ToString(context.Request["userTags"])).Split(UserTagManager.SplitCharacters, StringSplitOptions.RemoveEmptyEntries);
                    //    if (tagNames != null && tagNames.Length > 0)
                    //    {
                    //        foreach (string tagName in tagNames)
                    //        {
                    //            if (!string.IsNullOrEmpty(tagName.Trim()))
                    //            {
                    //                UserTag tag = UserTagManager.Instance(UserTagItemKeys.Instance().Photo()).GetUserTag(tagName.Trim(), photo.OwnerUserID, true);
                    //                if (tag == null)
                    //                {
                    //                    UserTag newTag = new UserTag();
                    //                    newTag.UserID = photo.OwnerUserID;
                    //                    newTag.TagName = StringUtils.Trim(tagName, 8, string.Empty);
                    //                    newTag.TagName = Formatter.CleanTagName(newTag.TagName);
                    //                    newTag.TagName = Formatter.FormatSingleLinePlainTextForStorage(newTag.TagName);

                    //                    if (UserTagManager.Instance(UserTagItemKeys.Instance().Photo()).CreateUserTag(newTag) > 0)
                    //                    {
                    //                        selectedTags.Add(newTag);
                    //                    }

                    //                }
                    //                else
                    //                {
                    //                    selectedTags.Add(tag);
                    //                }

                    //            }
                    //        }
                    //    }
                    //}

                    //photo.IsPublic = Convert.ToBoolean(context.Request["ynPublic"]);
                    //photo.PrivacyStatus = (PrivacyStatuses)(int.Parse(context.Request["setPhotoPirvacyStatus"]));
                    //photo.Password = Convert.ToString(context.Request["setPhotoPirvacyStatus_Password"]);

                    //创建的时候使有各种属性！
                    Attachment attachment = new Attachment(PhotoAttachmentManager.Instance().StorageProviderName, null);
                    attachment.ContentSize = context.Request.Files["Filedata"].ContentLength;
                    attachment.ContentType = context.Request.Files["Filedata"].ContentType;
                    attachment.DateCreated = DateTime.Now;
                    //attachment.FileName = context.Request.Files["Filedata"].FileName;
                    attachment.FriendlyFileName = context.Request.Files["Filedata"].FileName;
                    photo.Attachment = attachment;
                    photo.Subject = attachment.FriendlyFileName.Substring(0, attachment.FriendlyFileName.LastIndexOf('.'));

                    PhotoThreads.CreateThread(photo, null, context.Request.Files["Filedata"].InputStream);

                    UserCategoryManager.Instance(UserCategoryItemKeys.Instance().Photo()).UpdateCategoryItemCountCache(photo.UserCategoryID, 1);

                    if (photo.UserCategory != null && photo.UserCategory.FeaturedItemID <= 0)
                    {
                        photo.UserCategory.FeaturedItemID = photo.ThreadID;
                        UserCategoryManager.Instance(UserCategoryItemKeys.Instance().Photo()).UpdateUserCategory(photo.UserCategory);
                    }
                }
            }
            context.Response.StatusCode = 200;
            context.Response.Write("{ok:true}");
            context.Response.End();
        }

        #endregion
    }
}
