//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Collections;
using SpaceBuilder.Common;


namespace SpaceBuilder.Photo.Modules
{
    /// <summary>
    /// Զ
    /// </summary>
    public class AutoInstallPhotoApplication : IGlobalModule
    {
        /// <summary>
        /// 캯
        /// </summary>
        public AutoInstallPhotoApplication() { }

        /// <summary>
        /// ʼ
        /// </summary>
        public void Init(GlobalEventManager csa, System.Xml.Linq.XElement node)
        {
            csa.AfterUserChange += new UserEventHandler(csa_PostUserUpdate);
        }

        private void csa_PostUserUpdate(User user, GlobalEventArgs e)
        {
            if (user != null && e.State == ObjectState.Create)
            {
                PhotoConfiguration config = PhotoConfiguration.Instance();
                if (config.AutoCreatePhotoSection)
                {
                    Applications.InstallApplication(user.UserType == UserTypes.PersonUser ? PresentAreaIDs.Instance().UserDomain() : PresentAreaIDs.Instance().CompanyUserDomain(), user.UserID, ApplicationIDs.Instance().Photo());
                }
            }
        }
    }
}
