//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common;

using SpaceBuilder.Web;
using SpaceBuilder.Utils;
using SpaceBuilder.Common.Mail;

namespace SpaceBuilder.Photo.Modules
{
    /// <summary>
    /// Ķ̬֪ͨ
    /// </summary>
    public class DisposeNoticeForPhotoSection : IPhotoModule
    {

        #region IPostModule Ա
        public void Init(PhotoEventManager pem, System.Xml.Linq.XElement node)
        {
            pem.AfterPhotoCommentChange += new PhotoPostEventHandler(pem_AfterPhotoCommentChange);
            pem.AfterTagUserInPhotoChange += new TagUserInPhotoEventHandler(pem_AfterTagUserInPhotoChange);
        }

        void pem_AfterPhotoCommentChange(PhotoComment photoComment, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                PhotoThread photo = PhotoThreads.GetThread(photoComment.ThreadID, null, false);

                if (photoComment.UserID == photo.OwnerUserID)
                    return;

                string itemKey = NoticeItemKeys.Instance().NewPhotoComment();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;
                User toUser = null;
                if (photoComment.ParentID > 0)
                {
                    PhotoComment parentComment = PhotoComments.Get(photoComment.ParentID, null, false);
                    if (parentComment != null)
                        toUser = Users.GetUser(parentComment.UserID, false);
                }
                else
                    toUser = Users.GetUser(photo.OwnerUserID, false);
                if (toUser == null)
                    return;

                NoticeRecord record = new NoticeRecord();
                record.UserID = toUser.UserID;
                record.Receiver = toUser.DisplayName;
                record.ApplicationID = ApplicationIDs.Instance().Photo();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.LeadingActorUserID = photoComment.UserID;
                record.LeadingActor = photoComment.Author;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Photo());
                record.RelativeItemID = photo.ThreadID;
                record.RelativeItemName = photo.Subject;
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewPhotoComment", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(photoComment.UserID, photoComment.Author, true), GetPhotoNameWithHyperlink(photo, photoComment));
                record.RelativeItemUrl = SiteUrls.Instance().ShowPicture(UserID2UserNameDictionary.GetUserName(photo.OwnerUserID), photo.ThreadID);
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        void pem_AfterTagUserInPhotoChange(TagUserInPhoto tagUserInPhoto, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                User user = Users.GetUser(tagUserInPhoto.OperatorUserID, false);
                User toUser = Users.GetUser(tagUserInPhoto.UserID, false);
                PhotoThread photo = PhotoThreads.GetThread(tagUserInPhoto.ThreadID, null, false);
                if (user == null || toUser == null || photo == null)
                    return;

                string itemKey = NoticeItemKeys.Instance().NewTagUserInPhoto();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;



                NoticeRecord record = new NoticeRecord();
                record.UserID = tagUserInPhoto.UserID;
                record.Receiver = toUser.DisplayName;
                record.ApplicationID = ApplicationIDs.Instance().Photo();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.LeadingActorUserID = tagUserInPhoto.OperatorUserID;
                record.LeadingActor = user.DisplayName;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Photo());
                record.RelativeItemID = tagUserInPhoto.ThreadID;
                record.RelativeItemName = photo.Subject;
                record.Subject = string.Format("{0}Ƭ<a href=\"{1}\">{2}</a>аȦ˳", SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), SiteUrls.Instance().ShowPicture(UserID2UserNameDictionary.GetUserName(photo.OwnerUserID), photo.ThreadID), photo.Subject); ;
                record.RelativeItemUrl = SiteUrls.Instance().ShowPicture(UserID2UserNameDictionary.GetUserName(photo.OwnerUserID), photo.ThreadID);
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        /// <summary>
        /// ȡӵͼƬƵhtml
        /// </summary>
        private static string GetPhotoNameWithHyperlink(PhotoThread photo, PhotoComment comment)
        {
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowPicture(UserID2UserNameDictionary.GetUserName(photo.OwnerUserID), photo.ThreadID, comment.PostID), photo.Subject);
        }
        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;

        #endregion
    }

}
