﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Photo.Modules
{
    /// <summary>
    /// 删除用户时删除图片
    /// </summary>
    public class DisposePhotoSectionForDeleteUser : IGlobalModule
    {

        #region IGlobalModule 成员

        public void Init(GlobalEventManager gem, System.Xml.Linq.XElement node)
        {
            gem.UserDelete += new UserDeleteEventHandler(gem_UserDelete);

            gem.UserDeleteAndReassignContent += new UserDeleteEventHandler(gem_UserDeleteAndReassignContent);
        }

        void gem_UserDeleteAndReassignContent(User user, string reassignUserName)
        {
            try
            {
                PhotoThreads.DeleteUserAndReassignContent(user.UserID, reassignUserName);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error(ResourceManager.GetString("Message_DeleteUserAndMoveAlbumError",Globals.GetCurrentUserLanguage(),ApplicationIDs.Instance().Photo()), e);
            }
        }

        void gem_UserDelete(User user, string reassignUserName)
        {
            try
            {
                PhotoThreads.DeleteUser(user.UserID);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error(ResourceManager.GetString("Message_DeleteUserAndMoveAlbumError", Globals.GetCurrentUserLanguage(), ApplicationIDs.Instance().Photo()), e);
            }
        }
        #endregion
    }
}
