//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Photo.Modules
{
    /// <summary>
    /// صĻ
    /// </summary>
    public class DisposePointForPhotoSection : IPhotoModule
    {
        #region IPostModule Ա

        public void Init(PhotoEventManager pem, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                pem.AfterPhotoThreadPointChange += new PointChangeOfPhotoThreadHandler(pem_AfterPhotoThreadPointChange);
                pem.AfterPhotoCommentPointChange += new PointChangeOfPhotoCommentHandler(pem_AfterPhotoCommentPointChange);
                pem.AfterPhotoThreadSetEssential += new PhotoThreadEventHandler(pem_AfterPhotoThreadSetEssential);
                pem.AfterPhotoThreadSetSticky += new PhotoThreadEventHandler(pem_AfterPhotoThreadSetSticky);
            }
        }

        void pem_AfterPhotoCommentPointChange(PhotoComment photoComment, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;
            PhotoThread photo = PhotoThreads.GetThread(photoComment.ThreadID, null, false);
            User user = Users.GetUser(photoComment.UserID, false);
            if (user == null)
                return;
            if (userPointDirection == UserPointDirection.Input)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreatePhotoComment());
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateGalleryComment", photoComment.User.Language, e.ApplicationID), photo.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_PhotoCommentAuditingSuccess", photoComment.User.Language, e.ApplicationID), photo.Subject);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeletePhotoComment());
                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteGalleryComment", photoComment.User.Language, e.ApplicationID), HtmlUtils.TrimHtml(photoComment.Body, 128));
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_PhotoCommentAuditingFail", photoComment.User.Language, e.ApplicationID), HtmlUtils.TrimHtml(photoComment.Body, 128));
            }
            if (role == null)
                return;
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, photoComment.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

            Points.CreateUserPointRecords(records);
        }

        void pem_AfterPhotoThreadPointChange(PhotoThread photo, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;
            User user = Users.GetUser(photo.OwnerUserID, false);
            if (user == null)
                return;
            if (userPointDirection == UserPointDirection.Input)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreatePhotoThread());
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateGalleryThread", user.Language, e.ApplicationID), photo.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_PhotoThreadAuditingSuccess", user.Language, e.ApplicationID), photo.Subject);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeletePhotoThread());
                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteGalleryThread", user.Language, e.ApplicationID), photo.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_PhotoThreadAuditingFail", user.Language, e.ApplicationID), photo.Subject);
            }

            if (role == null)
                return;
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, photo.OwnerUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

            Points.CreateUserPointRecords(records);
        }

        void pem_AfterPhotoThreadSetSticky(PhotoThread photo, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Update && photo.SpecialOrder > 0)
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;
                User user = Users.GetUser(photo.OwnerUserID, false);
                if (user == null)
                    return;
                role = SpaceBuilder.Common.Points.GetUserPointItemRole(UserPointItemKeys.Instance().SetStickyPhotoThread());

                userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_SetStickyGalleryThread", user.Language, e.ApplicationID), photo.Subject);

                if (role == null)
                    return;
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, photo.OwnerUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                SpaceBuilder.Common.Points.CreateUserPointRecords(records);
            }
        }

        void pem_AfterPhotoThreadSetEssential(PhotoThread photo, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Update && photo.IsEssential)
            {
                UserPointItemRole role = null;
                User user = Users.GetUser(photo.OwnerUserID, false);
                if (user == null)
                    return;
                role = SpaceBuilder.Common.Points.GetUserPointItemRole(UserPointItemKeys.Instance().SetEssentialPhotoThread());

                if (role == null)
                    return;
                string userPointRecordDescription = userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_SetEssentialGalleryThread", user.Language, e.ApplicationID), photo.Subject);
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, photo.OwnerUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                SpaceBuilder.Common.Points.CreateUserPointRecords(records);
            }
        }

        #endregion

    }
}
