﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Common;


namespace SpaceBuilder.Photo.Modules
{
    public class DisposePointForRate : IServiceModule
    {
        #region IServiceModule 成员

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement node)
        {
            em.Rate += new RateEventHandler(em_Rate);
        }

        void em_Rate(Rating rating, GlobalEventArgs e)
        {
            if (e.ApplicationID == ApplicationIDs.Instance().Photo())
            {
                UserPointItemRole role = null;
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().RatePhotoThread());

                if (role == null)
                    return;
                string userPointRecordDescription = userPointRecordDescription = ResourceManager.GetString("Title_Point_RateGalleryThread", Globals.GetCurrentUserLanguage(), e.ApplicationID);
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, rating.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                Points.CreateUserPointRecords(records);
            }
        }

        #endregion


    }
}
