﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;


namespace SpaceBuilder.Photo.Modules
{
    /// <summary>
    /// 图片评论内容处理
    /// </summary>
    public class PhotoCommentFormatting : IPhotoModule
    {

        #region IPhotoModule 成员

        public void Init(PhotoEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforePhotoCommentChange += new PhotoPostEventHandler(em_BeforePhotoCommentChange);
        }

        void em_BeforePhotoCommentChange(PhotoComment photoComment, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                if (e.State == ObjectState.Create && SiteSettingsManager.GetSiteSettings().EnableTrackPostsByIP)
                    photoComment.UserHostAddress = WebUtils.IPAddress;

                //标签 脚本处理
                photoComment.Author = WebUtils.HtmlEncode(photoComment.Author);
                photoComment.Body = Formatter.FormatPlainTextComment(photoComment.Body);

                //敏感词处理
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    photoComment.Author = Censors.CensorPost(photoComment.Author);
                    photoComment.Body = Censors.CensorPost(photoComment.Body);
                }

                //表情图片处理
                if (SPBConfig.Instance().EnableEmoticon)
                {
                    photoComment.Body = EmotionManager.Instance().EmoticonTransforms(photoComment.Body);
                }
            }
        }

        #endregion
    }
}
