﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;


namespace SpaceBuilder.Photo.Modules
{
    /// <summary>
    /// 图片描述内容处理
    /// </summary>
    class PhotoFormatting : IPhotoModule
    {
        #region IPhotoModule 成员

        public void Init(PhotoEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforePhotoThreadChange += new PhotoThreadEventHandler(em_BeforePhotoThreadChange);
        }

        void em_BeforePhotoThreadChange(PhotoThread photo, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                if (e.State == ObjectState.Create && SiteSettingsManager.GetSiteSettings().EnableTrackPostsByIP)
                    photo.UserHostAddress = WebUtils.IPAddress;

                //标签 脚本处理
                photo.Subject = Formatter.FormatSingleLinePlainTextForStorage(photo.Subject);
                photo.BodyForDataTransmission = HtmlScrubber.Clean(photo.BodyForDataTransmission, false, true);

                //敏感词处理
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    photo.BodyForDataTransmission = Censors.CensorPost(photo.BodyForDataTransmission);
                }
            }
        }

        #endregion
    }
}
