﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;

using SpaceBuilder.Common;

namespace SpaceBuilder.Photo.Modules
{
    public class PhotoSectionFormatting : IPhotoModule
    {
        #region IPhotoModule 成员

        public void Init(PhotoEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforePhotoSeciontChange += new PhotoSectionEventHandler(em_BeforePhotoSeciontChange);
        }

        void em_BeforePhotoSeciontChange(PhotoSection photoSection, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                //标签 脚本处理
                photoSection.SectionName = WebUtils.HtmlEncode(photoSection.SectionName);
                photoSection.Description = WebUtils.HtmlEncode(photoSection.Description);

                //敏感词处理
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    photoSection.SectionName = Censors.CensorPost(photoSection.SectionName);
                    photoSection.Description = Censors.CensorPost(photoSection.Description);
                }
            }
        }

        #endregion
    }
}
