﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Photo
{
    public static class PhotoUserCookie
    {
        private static readonly char PhotoCookieKeyValueSeparator = ',';
        private static readonly char PhotoCookieContentSeparator = '|';

        private static readonly string AuthorizedPhotoCategoryCookieKey = "AuthorizedPhotoCategories";

        /// <summary>
        /// 保存已授权的照片分类ID集合
        /// </summary>
        public static void SaveAuthorizedPhotoCatetoryIDs(this UserCookie userCookieObject, int categoryID, string password)
        {
            //检测是否已存在于Cookie中
            if (userCookieObject.AuthorizePhotoCatetoryID(categoryID))
                return;
            if (userCookieObject.Cookie != null)
            {
                string oldCategoryIDs = userCookieObject.Cookie[AuthorizedPhotoCategoryCookieKey];
                userCookieObject.Cookie[AuthorizedPhotoCategoryCookieKey] = EncryptManager.EncryptTokenForInviteFriend(string.Format("{0}{1}{2},{3}", oldCategoryIDs, PhotoCookieContentSeparator, categoryID.ToString(), password));
                userCookieObject.WriteCookie();
            }
        }

        /// <summary>
        /// 获取已授权的照片分类ID集合
        /// </summary>
        /// <returns>
        /// 例如：1,2,6,
        /// </returns>
        public static bool AuthorizePhotoCatetoryID(this UserCookie userCookieObject, int categoryID)
        {
            if (userCookieObject.Cookie == null)
                return false;

            UserCategory category = UserCategoryManager.Instance(UserCategoryItemKeys.Instance().Photo()).GetUserCategory(categoryID, false);
            if (category == null)
                return false;

            string categoryIDs = EncryptManager.DecryptTokenForInviteFriend(userCookieObject.Cookie[AuthorizedPhotoCategoryCookieKey]);
            if (!string.IsNullOrEmpty(categoryIDs))
            {
                string[] categoryArray = categoryIDs.Split(new char[] { PhotoCookieContentSeparator }, StringSplitOptions.RemoveEmptyEntries);
                if (categoryArray != null && categoryArray.Length > 0)
                {
                    Dictionary<int, string> photoCategories = new Dictionary<int, string>();
                    foreach (string categoryStr in categoryArray)
                    {
                        string[] items = categoryStr.Split(new char[] { PhotoCookieKeyValueSeparator }, StringSplitOptions.RemoveEmptyEntries);
                        if (items != null && items.Length > 1)
                        {
                            int i = 0;
                            int.TryParse(items[0], out i);
                            if (i > 0)
                                photoCategories[i] = items[1];
                        }
                    }
                    return photoCategories.ContainsKey(categoryID) && UserCategoryManager.Instance(UserCategoryItemKeys.Instance().Photo()).ValidPrivacyPassword(photoCategories[categoryID], category.Password);
                }
            }
            return false;
        }

    }
}
