﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Web;

using System.Web.Mvc;
using SpaceBuilder.Common;
using System.Web.Routing;

namespace SpaceBuilder.Photo
{
    public static class SPBHtmlHelperExtensions
    {

        ///<overloads>显示相册图片</overloads>
        /// <summary>
        /// 显示相册图片
        /// </summary>
        public static string ShowPicture(this SPBHtmlHelper spbHtmlHelper, PhotoThread photo, PhotoImageType imageType)
        {
            return ShowPicture(spbHtmlHelper, photo.ThreadID, imageType, photo.Subject);
        }

        /// <summary>
        /// 根据PostID显示图片
        /// </summary>
        /// <param name="postID">显示图片的ID</param>
        public static string ShowPicture(this SPBHtmlHelper spbHtmlHelper, int threadID, PhotoImageType imageType)
        {
            PhotoThread photo = PhotoThreads.GetThread(threadID, null, false);
            if (photo == null)
                throw new ArgumentException(string.Format(ResourceManager.GetString("Exception_Pattern_CalleryNotExist", Globals.GetCurrentUserLanguage(), ApplicationIDs.Instance().Photo()), threadID));
            return ShowPicture(spbHtmlHelper, photo, imageType);
        }

        ///<overloads>显示相册图片</overloads>
        /// <summary>
        /// 显示相册图片
        /// </summary>
        public static string ShowPicture(this SPBHtmlHelper spbHtmlHelper, PhotoThread photo, PhotoImageType imageType, string navigateUrl)
        {
            return ShowPicture(spbHtmlHelper, photo.ThreadID, imageType, photo.Subject, navigateUrl, "_blank");
        }

        ///<overloads>显示相册图片</overloads>
        /// <summary>
        /// 显示相册图片
        /// </summary>
        public static string ShowPicture(this SPBHtmlHelper spbHtmlHelper, PhotoThread photo, PhotoImageType imageType, string navigateUrl, string navigateTarget)
        {
            return ShowPicture(spbHtmlHelper, photo.ThreadID, imageType, photo.Subject, navigateUrl, navigateTarget);
        }


        ///<overloads>显示相册图片</overloads>
        /// <summary>
        /// 显示相册图片
        /// </summary>
        /// <param name="pictureID">图片PostID</param>
        /// <param name="imageType">图片类型</param>
        /// <param name="toolTip">ToolTip</param>
        public static string ShowPicture(this SPBHtmlHelper spbHtmlHelper, int threadID, PhotoImageType imageType, string toolTip)
        {
            return ShowPicture(spbHtmlHelper, threadID, imageType, toolTip, null, null);
        }


        ///<overloads>显示相册图片</overloads>
        /// <summary>
        /// 显示相册图片
        /// </summary>
        /// <param name="pictureID">图片PostID</param>
        /// <param name="imageType">图片类型</param>
        /// <param name="navigateUrl">图片链接</param>
        /// <param name="toolTip">ToolTip</param>
        public static string ShowPicture(this SPBHtmlHelper spbHtmlHelper, int threadID, PhotoImageType imageType, string toolTip, string navigateUrl, string navigateTarget)
        {
            return ShowPicture(spbHtmlHelper, threadID, imageType, toolTip, navigateUrl, navigateTarget, string.Empty);
        }

        public static string ShowPicture(this SPBHtmlHelper spbHtmlHelper, int threadID, PhotoImageType imageType, string toolTip, string navigateUrl, string navigateTarget, string password)
        {
            return ShowPicture(spbHtmlHelper, threadID, imageType, toolTip, navigateUrl, navigateTarget, password, null);
        }

        ///<overloads>显示相册图片</overloads>
        /// <summary>
        /// 显示相册图片
        /// </summary>
        /// <param name="pictureID">图片PostID</param>
        /// <param name="imageType">图片类型</param>
        /// <param name="navigateUrl">图片链接</param>
        /// <param name="toolTip">ToolTip</param>
        /// <param name="password">访问密码</param>
        public static string ShowPicture(this SPBHtmlHelper spbHtmlHelper, int threadID, PhotoImageType imageType, string toolTip, string navigateUrl, string navigateTarget, string password, RouteValueDictionary htmlAttributes)
        {
            TagBuilder img = new TagBuilder("img");

            img.MergeAttribute("src", SiteUrls.Instance().PictureUrl(threadID, imageType, password));

            if (!string.IsNullOrEmpty(toolTip))
            {
                img.MergeAttribute("alt", toolTip);
                img.MergeAttribute("title", toolTip);
            }

            if (htmlAttributes != null)
                img.MergeAttributes(htmlAttributes);

            if (string.IsNullOrEmpty(navigateUrl))
            {
                return img.ToString(TagRenderMode.SelfClosing) + new TagBuilder("span").ToString(TagRenderMode.Normal);
            }
            else
            {
                TagBuilder a = new TagBuilder("a");

                a.MergeAttribute("href", navigateUrl);

                if (!string.IsNullOrEmpty(navigateTarget))
                    a.MergeAttribute("target", navigateTarget);

                a.InnerHtml = img.ToString();
                a.InnerHtml += new TagBuilder("span").ToString(TagRenderMode.Normal);

                return a.ToString();
            }
        }
    }
}

