﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Photo
{

    /// <summary>
    /// 图片全文检索查询类
    /// </summary>
    public class PhotoFullTextQuery
    {
        /// <summary>
        /// 搜索范围限定 UserID
        /// </summary>
        public int SearchScopeUserID = -1;

        /// <summary>
        /// SiteCategoryID
        /// </summary>
        public int SiteCategoryID = -1;

        /// <summary>
        /// 是否包含SiteCategoryID的子孙类别
        /// </summary>
        public bool IncludeSiteCategoryDescendant = true;

        /// <summary>
        /// 关键字
        /// </summary>
        public string Keyword = string.Empty;

        /// <summary>
        /// 标签
        /// </summary>
        public string TagName = null;

        /// <summary>
        /// 作者
        /// </summary>
        public string Author = string.Empty;

        /// <summary>
        /// 是否公开
        /// </summary>
        public bool IsPublicFilter = true;

        /// <summary>
        /// 排序字段
        /// </summary>
        public FullTextQueryPhotosSortBy SortBy = FullTextQueryPhotosSortBy.Relevance;

        /// <summary>
        /// 当前显示页面页码
        /// </summary>
        private int pageIndex = 1;
        public int PageIndex
        {
            get
            {
                if (pageIndex < 1)
                    return 1;
                else
                    return pageIndex;
            }
            set { pageIndex = value; }
        }

        /// <summary>
        /// 每页显示记录数
        /// </summary>
        public int PageSize = 20;

        /// <summary>
        /// 查询条件是否有效
        /// </summary>
        public bool IsValid()
        {
            if (SearchScopeUserID > 0 || SiteCategoryID > 0 || !string.IsNullOrEmpty(Keyword) || !string.IsNullOrEmpty(Author) || !string.IsNullOrEmpty(TagName))
                return true;
            else
                return false;
        }

        /// <summary>
        /// 从QueryString获取查询条件
        /// </summary>
        public void ConvertFromQueryString(System.Web.HttpRequestBase request)
        {
            if (!string.IsNullOrEmpty(request.QueryString["SearchScopeUserID"]))
                int.TryParse(request.QueryString["SearchScopeUserID"], out this.SearchScopeUserID);

            if (!string.IsNullOrEmpty(request.QueryString["SiteCategoryID"]))
                int.TryParse(request.QueryString["SiteCategoryID"], out this.SiteCategoryID);

            if (!string.IsNullOrEmpty(request.QueryString["IncludeSiteCategoryDescendant"]))
                bool.TryParse(request.QueryString["IncludeSiteCategoryDescendant"], out this.IncludeSiteCategoryDescendant);

            if (!string.IsNullOrEmpty(request.QueryString["Keyword"]))
                this.Keyword = request.QueryString["Keyword"];

            if (!string.IsNullOrEmpty(request.QueryString["TagName"]))
                this.TagName = request.QueryString["TagName"];

            if (!string.IsNullOrEmpty(request.QueryString["Author"]))
                this.Author = request.QueryString["Author"];

            if (!string.IsNullOrEmpty(request.QueryString["IsPublicFilter"]))
                bool.TryParse(request.QueryString["IsPublicFilter"], out this.IsPublicFilter);

            if (!string.IsNullOrEmpty(request.QueryString["SortBy"]))
            {
                int sortByValue;
                int.TryParse(request.QueryString["SortBy"], out sortByValue);
                this.SortBy = (FullTextQueryPhotosSortBy)sortByValue;
            }

            if (!string.IsNullOrEmpty(request.QueryString["PaseSize"]))
                int.TryParse(request.QueryString["PaseSize"], out this.PageSize);
        }

    }


    /// <summary>
    /// 图片全文检索排序字段
    /// </summary>
    public enum FullTextQueryPhotosSortBy
    {
        /// <summary>
        /// 相关性
        /// </summary>
        /// <remarks>
        /// 全文索引库默认排序方式
        /// </remarks>
        Relevance = 0,

        /// <summary>
        /// 创建日期
        /// </summary>
        DateCreated = 1
    }

}
