﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Tasks;
using System.Xml;
using SpaceBuilder.Common;
using SpaceBuilder.Photo;

using SpaceBuilder.Utils;
using System.Xml.Linq;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// 定期把Photo的变更情况更新到Lucene索引文件
    /// </summary>
    public class PhotoIndexTask : TaskBase
    {
        /// <summary>
        /// 每次更新索引的最大数目
        /// </summary>
        private int count = 1000;

        #region ITask Members

        public override void ExecuteTask(XElement xElement)
        {
            XAttribute countNode = xElement.Attribute("count");
            if (countNode != null)
            {
                int.TryParse(countNode.Value, out count);
            }
            IndexPosts(count);
        }

        #endregion

        private void IndexPosts(int count)
        {
            SearchDataProvider dp = SearchDataProvider.Instance();
            IList<ItemForIndex> itemsForIndex = dp.GetItemsForIndex(PhotoSearchTypeSettings.CODE, count);

            IList<ItemForIndex> createItems = new List<ItemForIndex>();
            IList<ItemForIndex> updateItems = new List<ItemForIndex>();
            IList<ItemForIndex> deleteItems = new List<ItemForIndex>();

            foreach (ItemForIndex item in itemsForIndex)
            {
                if (item.DataAction == ObjectState.Create)
                    createItems.Add(item);
                else if (item.DataAction == ObjectState.Update)
                    updateItems.Add(item);
                else if (item.DataAction == ObjectState.Delete)
                    deleteItems.Add(item);
            }

            PhotoSearchManager searchManager = PhotoSearchManager.Instance();
            #region Insert

            IList<PhotoThread> createPosts = new List<PhotoThread>();
            foreach (ItemForIndex item in createItems)
            {
                PhotoThread p = PhotoThreads.GetThread(item.ItemID, PrivacyStatuses.Public, true);
                if (p != null)
                    createPosts.Add(p);
            }

            if (searchManager.Insert(createPosts))
            {
                dp.DeleteItemsForIndex(createItems);
            }
            else
            {
                foreach (ItemForIndex item in createItems)
                {
                    item.DataAction = ObjectState.Update;
                }
                dp.UpdateItemsForIndex(createItems);
            }

            #endregion

            #region Update

            IList<PhotoThread> updatePosts = new List<PhotoThread>();
            foreach (ItemForIndex item in updateItems)
            {
                PhotoThread p = PhotoThreads.GetThread(item.ItemID, PrivacyStatuses.Public, true);
                if (p != null)
                    updatePosts.Add(p);
            }

            if (searchManager.Update(updatePosts, m => m.Select(n => n.ThreadID).ToList(), PhotoIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(updateItems);
            }

            #endregion

            #region Delete
            if (deleteItems.Count > 0 && searchManager.Delete(deleteItems.Select(n => n.ItemID).ToList(), PhotoIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(deleteItems);
            }
            #endregion
        }
    }
}