﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Photo;
using SpaceBuilder.Common;
using SpaceBuilder.Web;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// SearchType配置
    /// </summary>
    public class PhotoSearchTypeSettings : SearchTypeSettingsBase
    {
        /// <summary>
        /// 搜索类型编码
        /// </summary>
        public static readonly string CODE = "011201";


        #region SearchTypeSettingsBase 成员

        /// <summary>
        /// 搜索类型编码
        /// </summary>
        /// <remarks>
        /// 1、SearchCode必须唯一
        /// 2、SearchCode命名规范: {4位ApplicationID,位数不足左侧补零}{2位编码} 
        /// </remarks>
        public override string SearchTypeCode 
        {
            get { return CODE; }
        }

        /// <summary>
        /// 索引文件所在目录
        /// </summary>
        public override string IndexFileDirectory
        {
            get { return PhotoSearchManager.Instance().IndexFileDirectory; }
        }

        private bool isSimulated = false;
        /// <summary>
        /// 没有采用全文检索,仅是伪装成全文检索
        /// </summary>
        public override bool IsSimulated
        {
            get { return isSimulated; }
        }


        /// <summary>
        /// ApplicationID
        /// </summary>
        public override int ApplicationID
        {
            get { return ApplicationIDs.Instance().Photo(); }
        }

        /// <summary>
        /// 初始化索引
        /// </summary>
        /// <param name="indexPath">索引文件路径</param>
        public override void InitializeIndex(string indexPath)
        {
            PhotoSearchManager.Instance().InitializeIndex(indexPath);
        }

        #endregion

        public override string SearchAtionUrl
        {
            get { return SPBUrlHelper.RouteUrl("Channel_Photo_Search"); }
        }
    }
}
