﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Photo;
using SpaceBuilder.Common;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// 处理图片的变更，把变更情况记录到数据库，并在<see cref="SpaceBuilder.LuceneSearch.PhotoIndexTask"/>批量更新到Lucene索引文件中
    /// </summary>
    public class PrepareForPhotoIndexModule : IPhotoModule
    {
        #region IPhotoModule 成员

        public void Init(PhotoEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterPhotoThreadChange += new PhotoThreadEventHandler(em_AfterPhotoThreadChange);
        }
        

        void em_AfterPhotoThreadChange(PhotoThread photo, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if ((photo != null) && (e.State == ObjectState.Create || e.State == ObjectState.Update || e.State == ObjectState.Delete))
            {
                if (photo.PrivacyStatus == PrivacyStatuses.Public)
                {
                    ItemForIndex item = new ItemForIndex();
                    item.ItemID = photo.ThreadID;
                    item.SearchTypeCode = PhotoSearchTypeSettings.CODE;
                    item.DataAction = e.State;

                    SearchDataProvider.Instance().CreateUpdateDeleteItemForIndex(item, DataProviderAction.Create);
                }
            }
        }

        #endregion
    }
}
