﻿//------------------------------------------------------------------------------
//<copyright company="Tunynet">
// Copyright (c) Tunynet Inc.  All rights reserved.
//</copyright> 
//------------------------------------------------------------------------------ 

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using System.Web.Routing;



namespace SpaceBuilder.Photo
{
    /// <summary>
    /// 相册相关Url
    /// </summary>
    public static class SiteUrlsExtensions
    {

        /// <summary>
        /// 图片频道首页
        /// </summary>
        public static string ChannelPhotoHome(this SiteUrls siteUrls)
        {
            return SPBUrlHelper.RouteUrl("Channel_Photo_Home");
        }

        /// <summary>
        /// 上传图片
        /// </summary>
        public static string PhotoUpload(this SiteUrls siteUrls)
        {
            //return WebUtils.ResolveUrl("~/Services/Photo/UploadPhotoAttachments.ashx");
            return Globals.GetFullUrlInFileHandlerSite(PhotoAttachmentManager.Instance().StorageProviderName, WebUtils.ResolveUrl("~/Services/Photo/UploadPhotoAttachments.ashx"));
        }

        #region Photo

        /// <summary>
        /// 返回RSS订阅相册图片的Url
        /// </summary>
        /// <param name="userDomainName">相册主人userDomainName</param>
        /// <returns>RSS订阅相册图片Url</returns>
        public static string GalleryRss(this SiteUrls siteUrls, string userDomainName)
        {
            return WebUtils.ResolveUrl(string.Format("~/Services/Photo/rss.ashx?userDomainName={0}", userDomainName));
        }

        /// <summary>
        /// 返回RSS订阅相簿图片到Url
        /// </summary>
        /// <param name="userDomainName">相册主人userDomainName</param>
        /// <returns>RSS订阅相册图片Url</returns>
        public static string PhotoCategoryRss(this SiteUrls siteUrls, string userDomainName, int categoryID)
        {
            return WebUtils.ResolveUrl(string.Format("~/Services/Photo/rss.ashx?userDomainName={0}&CategoryID={1}", userDomainName, categoryID));
        }

        /// <summary>
        /// 根据图片PostID获取图片略大缩略图Url
        /// </summary>
        public static string PictureUrl(this SiteUrls siteUrls, int threadID, PhotoImageType imageType)
        {
            return PictureUrl(siteUrls, threadID, imageType, string.Empty);
        }

        /// <summary>
        /// 根据图片PostID获取图片略大缩略图Url
        /// </summary>
        public static string PictureUrl(this SiteUrls siteUrls, int threadID, PhotoImageType imageType, string password)
        {
            PhotoThread photo = PhotoThreads.GetThread(threadID, null, false);
            if (photo == null)
                return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/album_nophoto.gif");

            if (FileStorageProvider.Instance(PhotoAttachmentManager.Instance().StorageProviderName).EnableDirectlyUrl)
            {
                if (!SpaceBuilder.Photo.Handlers.ShowPhotoHandler.UserCanView(photo, imageType))
                    return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/album_nophoto.gif");

                return PhotoAttachmentManager.Instance().GetDirectlyUrl(photo.Attachment, imageType);
            }

            if (string.IsNullOrEmpty(password))
                return Globals.GetFullUrlInFileHandlerSite(PhotoAttachmentManager.Instance().StorageProviderName, string.Format("~/Services/Photo/Picture.ashx?threadID={0}&ImageType={1}", threadID, (int)imageType));
            else
                return Globals.GetFullUrlInFileHandlerSite(PhotoAttachmentManager.Instance().StorageProviderName, string.Format("~/Services/Photo/Picture.ashx?threadID={0}&ImageType={1}&password={2}", threadID, (int)imageType, password));
        }

        /// <summary>
        /// 相簿特征图片Url
        /// </summary>
        public static string CategoryFeaturedPhotoUrl(this SiteUrls siteUrls, UserCategory userCategory)
        {
            if (userCategory.FeaturedItemID > 0)
                return PictureUrl(siteUrls, userCategory.FeaturedItemID, PhotoImageType.Icon);
            else
                return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/album_nophoto.gif");
        }

        /// <summary>
        /// 相簿不同尺寸特征图片Url
        /// </summary>
        public static string CategoryFeaturedPhotoUrl(this SiteUrls siteUrls, UserCategory userCategory, PhotoImageType imageType)
        {
            if (userCategory.FeaturedItemID > 0)
            {
                return PictureUrl(siteUrls, userCategory.FeaturedItemID, imageType);
            }
            else
                return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/album_nophoto.gif");
        }

        /// <summary>
        /// 处理批量上传图片的Handler
        /// </summary>
        public static string Admin_UploadPicturesHandler(this SiteUrls siteUrls, int userID, int sectionID)
        {
            return Globals.GetFullUrlInFileHandlerSite(PhotoAttachmentManager.Instance().StorageProviderName, string.Format("~/Services/Photo/UploadPictures.ashx?userID={0}&SectionID={1}", userID, sectionID));
        }

        #endregion

        #region Photo

        /// <summary>
        /// 显示图片详细信息
        /// </summary>
        /// <returns></returns>
        public static string ShowPicture(this SiteUrls siteUrls, string userDomainName, int threadID)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Photo_ShowPhoto", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "threadID", threadID } });
        }
        /// <summary>
        /// 显示图片详细信息
        /// </summary>
        /// <returns></returns>
        public static string ShowPicture(this SiteUrls siteUrls, string userDomainName, int threadID, int childPostID)
        {
            return ShowPicture(siteUrls, userDomainName, threadID) + "#" + childPostID;
        }

        /// <overloads>查看相簿图片</overloads>
        /// <summary>
        /// 查看相簿图片
        /// </summary>
        /// <param name="applicationKey">相册功能模块标识</param>
        /// <param name="categoryID">图片类别ID</param>
        public static string ShowPhotoCategory(this SiteUrls siteUrls, string userName, int categoryID)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Photo_Common", new RouteValueDictionary { { "UserDomainName", userName }, { "action", "ListThumbnailPhotosByCategory" }, { "categoryID", categoryID } });
        }

        #endregion

        /// <summary>
        /// 根据用户标签列表显示照片
        /// </summary>
        public static string ListPhotosByUserTag(this SiteUrls siteUrls, string userDomainName, string tagName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Photo_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "ListPhotosByTag" }, { "tagName", WebUtils.UrlEncode(tagName) } });
        }

        /// <summary>
        /// 根据站点标签列表显示照片
        /// </summary>
        public static string ListPhotosBySiteTag(this SiteUrls siteUrls, string tagName)
        {
            return SPBUrlHelper.RouteUrl("Channel_Photo_ListPhotosByTag", new RouteValueDictionary { { "tagName", WebUtils.UrlEncode(tagName) } });
        }

    }
}
