﻿//<TunynetCopyright>
//--------------------------------------------------------------
//<copyright>拓宇网络科技有限公司 2005-2009</copyright>
//<version>V2.3</verion>
//<createdate>2009-11-4</createdate>
//<author>chenq</author>
//<email>chenq@tunynet.com</email>
//<log date="2009-11-4">创建</log>
//--------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common.Controllers;
using System.Web.Mvc;
using System.Web.Routing;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using SpaceBuilder.Share;

namespace SpaceBuilder.Share.Controllers
{
    [ManageAuthorize]
    [HttpCompress]
    public class ManageShareController : ManageControllerBase
    {

        /// <summary>
        /// 分享应用ID
        /// </summary>
        private int applicationID = ApplicationIDs.Instance().Share();

        #region Share

        #region View

        /// <summary>
        /// 显示编辑分享页面
        /// </summary>
        public ActionResult ShareDialog(int threadID, int userID, int? pageIndex)
        {
            UserShareThread userShareThread = UserShareThreads.GetThread(userID, threadID, true);
            if (userShareThread == null)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_UpdateAborted", applicationID);
                return RedirectToAction("ManageShareThreads", new RouteValueDictionary { { "pageIndex", pageIndex ?? 1 } });
            }
            ViewData["pageIndex"] = pageIndex ?? 1;
            return View("Pages/Shares/ShareDialog.aspx", userShareThread);
        }

        /// <summary>
        /// 站点分享管理
        /// </summary>
        /// <param name="userID"></param>
        /// <param name="subjectKeyWords"></param>
        /// <param name="auditingStatusForDisplay"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        public ActionResult ManageShareThreads(int? userID, string subjectKeyWords, AuditingStatusesForDisplay? auditingStatusForDisplay, int? pageIndex)
        {

            SetPageTitle(GetResourceString("Title_ShareManage", applicationID));
            auditingStatusForDisplay = auditingStatusForDisplay ?? AuditingStatusesForDisplay.Pending;
            ViewData["AuditingStatusForDisplay"] = auditingStatusForDisplay;
            PagingDataSet<ShareThread> pds = ShareThreads.GetThreadsForAdmin(userID ?? 0, subjectKeyWords, auditingStatusForDisplay, 20, pageIndex ?? 1);
            return View("Pages/Shares/ManageShareThreads.aspx", "Masters/Share.master", pds);
        }

        /// <summary>
        /// 站点类别列表
        /// </summary>
        /// <returns></returns>
        public ActionResult ShareCategories()
        {
            SetPageTitle(GetResourceString("Title_BlogManage", applicationID));
            ViewData["SiteCategoryDepth"] = ShareConfiguration.Instance().SiteCategoryLevel - 1;
            return View("Pages/Blog/ManageBlogCategories.aspx", "Masters/Share.master");
        }

        #endregion

        #region Operation

        /// <summary>
        /// 删除单个分享
        /// </summary>
        /// <param name="threadID"></param>
        /// <param name="returnUrl"></param>
        /// <returns></returns>
        public ActionResult DeleteShareThread(int threadID, string returnUrl)
        {
            ShareThread thread = ShareThreads.GetThread(threadID, true);
            if (thread == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ShareNotFound", applicationID), threadID)));
            }
            ShareThreads.DeleteThread(threadID);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = GetResourceString("Message_DeleteSucceed", applicationID);


            return Redirect(returnUrl);
        }

        /// <summary>
        /// 批量删除分享
        /// </summary>
        /// <param name="returnUrl"></param>
        /// <returns></returns>
        public ActionResult DeleteShareThreads(string returnUrl)
        {
            string selectIDsString = Request.Form["ManageSharesCheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectIDsString))
            {
                string[] selectIDsStringArray = selectIDsString.Split(',');
                if (CurrentUser != null && (selectIDsStringArray != null && selectIDsStringArray.Length > 0 && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator)))
                {
                    foreach (string strThreadID in selectIDsStringArray)
                    {
                        int threadID = int.Parse(strThreadID);
                        ShareThreads.DeleteThread(threadID);
                    }
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_DeleteBatchSucceed", applicationID);
                }
                else
                {
                    TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                    TempData["StatusMessageContent"] = GetResourceString("Message_DeleteBatchAborted", applicationID);
                }
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 批量更新分享审核状态
        /// </summary>
        /// <param name="isPass"></param>
        /// <param name="returnUrl"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult SetShareAuditingStatus(bool isPass, string returnUrl)
        {

            string selectIDsString = Request.Form["ManageSharesCheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectIDsString))
            {
                string[] selectIDsStringArray = selectIDsString.Split(',');
                if (CurrentUser != null && (selectIDsStringArray != null && selectIDsStringArray.Length > 0 && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator)))
                {
                    List<int> threadIDs = new List<int>();
                    foreach (string idString in selectIDsStringArray)
                    {
                        int threadID = int.Parse(idString);
                        if (threadID > 0)
                            threadIDs.Add(threadID);
                    }
                    if (isPass)
                        ShareThreads.UpdateAuditingStatus(threadIDs, AuditingStatuses.Success);
                    else
                        ShareThreads.UpdateAuditingStatus(threadIDs, AuditingStatuses.Fail);
                    TempData["StautsMessageType"] = (int)StatusMessageType.Success;
                    TempData["StautsMessageContent"] = GetResourceString("Message_UpdateSucceed", applicationID);
                }
                else
                {
                    TempData["StautsMessageType"] = (int)StatusMessageType.Error;
                    TempData["StautsMessageContent"] = GetResourceString("Message_UpdateAborted", applicationID);
                }
            }
            else
            {
                TempData["StautsMessageType"] = (int)StatusMessageType.Error;
                TempData["StautsMessageContent"] = GetResourceString("Message_ChooseUpdateingShare", applicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 搜索分享
        /// </summary>
        /// <param name="auditingStautsesForDisplay"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult SearchShareThreads(AuditingStatusesForDisplay auditingStautsesForDisplay)
        {
            string subjectKeyWords = Request.Form.GetString("subjectKeywords", string.Empty).Trim();
            string userID = Request.Form["userID"];

            return RedirectToAction("ManageShareThreads", new RouteValueDictionary { { "auditingStatusForDisplay", auditingStautsesForDisplay }, { "userID", userID }, { "subjectKeyWords", subjectKeyWords } });

        }

        #endregion

        #endregion

        #region ShareComment

        #region View

        /// <summary>
        /// 分享评论管理
        /// </summary>
        /// <param name="userID"></param>
        /// <param name="bodyKeyWords"></param>
        /// <param name="auditingStatusForDisplay"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        public ActionResult ManageShareComments(int? userID, string bodyKeyWords, AuditingStatusesForDisplay? auditingStatusForDisplay, int? pageIndex)
        {

            SetPageTitle(GetResourceString("Title_ManageShareCommont", applicationID));
            auditingStatusForDisplay = auditingStatusForDisplay ?? AuditingStatusesForDisplay.Pending;
            ViewData["auditingStatusForDisplay"] = auditingStatusForDisplay;
            PagingDataSet<ShareComment> pds = ShareComments.GetCommentsForAdmin(20, pageIndex ?? 1, auditingStatusForDisplay, userID ?? 0, bodyKeyWords);
            return View("Pages/Shares/ManageShareComments.aspx", "Masters/Share.master", pds);
        }

        #endregion

        #region Operation


        /// <summary>
        /// 删除评论
        /// </summary>
        /// <param name="commentID"></param>
        /// <param name="returnUrl"></param>
        /// <returns></returns>
        public ActionResult DeleteComment(int commentID, string returnUrl)
        {

            ShareComment comment = ShareComments.GetComment(commentID, true);
            if (comment != null)
            {
                ShareComments.DeleteComment(commentID);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = GetResourceString("Message_DeleteCommontSucceed", applicationID);
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_DeleteCommontAborted", applicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 批量删除评论
        /// </summary>
        /// <param name="returnUrl"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult DeleteComments(string returnUrl)
        {
            string[] deleteCommentIDs = Request.Form.GetString("CheckBoxGroup", string.Empty).Split(',');
            if (deleteCommentIDs != null && deleteCommentIDs.Length > 0)
            {
                int commentID = 0;
                List<int> commentIDs = new List<int>();
                foreach (string strCommentID in deleteCommentIDs)
                {
                    int.TryParse(strCommentID, out commentID);
                    commentIDs.Add(commentID);

                }
                ShareComments.DeleteComments(commentIDs);
                TempData["StatusMessageType"] = StatusMessageType.Success;
                TempData["StatusMessageContent"] = GetResourceString("Message_DeleteBatchSucceed", applicationID);
            }
            else
            {
                TempData["StatusMessageType"] = StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_DeleteBatchAborted", applicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 设置评论审核状态
        /// </summary>
        /// <param name="auditingStatuses"></param>
        /// <param name="returnUrl"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult SetCommentAuditingStatus(AuditingStatuses? auditingStatuses, string returnUrl)
        {
            string[] StrCommentIDs = Request.Form.GetString("CheckBoxGroup", string.Empty).Split(',');

            if (StrCommentIDs != null && StrCommentIDs.Length > 0)
            {
                List<int> commentIDs = new List<int>();
                int commentID = 0;
                foreach (string strCommentID in StrCommentIDs)
                {
                    int.TryParse(strCommentID, out commentID);
                    commentIDs.Add(commentID);
                }

                ShareComments.UpdateAuditingStatus(commentIDs, auditingStatuses.Value);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = GetResourceString("Message_SetSucceed", applicationID);
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_SetAborted", applicationID);
            }

            return Redirect(returnUrl);
        }

        /// <summary>
        /// 搜索评论
        /// </summary>
        /// <param name="auditingStautsesForDisplay"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult SearechShareComments(AuditingStatusesForDisplay auditingStatusForDisplay)
        {
            string bodyKeyWords = Request.Form.GetString("bodyKeywords", string.Empty);
            string userID = Request.Form["UserID"];
            return RedirectToAction("ManageShareComments", new RouteValueDictionary { { "auditingStatusForDisplay", auditingStatusForDisplay }, { "bodyKeyWords", bodyKeyWords }, { "userID", userID } });

        }

        #endregion

        #region 站点标签管理
        /// <summary>
        /// 站点标签管理
        /// </summary>       
        public ActionResult ManageSiteTags()
        {
            return View("Pages/Shares/ManageSiteTags.aspx", "Masters/Share.master");
        }

        #endregion

        public ActionResult ManageShareSiteCategories()
        {
            return View("Pages/Shares/ManageShareCategories.aspx", "Masters/Share.master");
        }

        #endregion

        /// <summary>
        /// 获取分享数据统计
        /// </summary>
        /// <returns></returns>
        public JsonResult GetManageableCounts()
        {
            Dictionary<ShareManageableCounts, int> dictionary = ShareThreads.GetManageableCounts();
            Application shareApplication = Applications.GetApplication(ApplicationIDs.Instance().Share());
            List<ManageableCount> list = new List<ManageableCount>();
            list.Add(new ManageableCount { Name = "新增分享", Value = shareApplication.CountInPast24Hours });
            if (dictionary.ContainsKey(ShareManageableCounts.PendingThreadCount))
                list.Add(new ManageableCount { Name = "待审核分享", Value = dictionary[ShareManageableCounts.PendingThreadCount], Url = SPBUrlHelper.Action("ManageShareThreads", "ManageShare", new RouteValueDictionary { { "auditingStatusForDisplay", AuditingStatusesForDisplay.Pending } }) });
            if (dictionary.ContainsKey(ShareManageableCounts.AgainThreadCount))
                list.Add(new ManageableCount { Name = "需再审核分享", Value = dictionary[ShareManageableCounts.AgainThreadCount], Url = SPBUrlHelper.Action("ManageShareThreads", "ManageShare", new RouteValueDictionary { { "auditingStatusForDisplay", AuditingStatusesForDisplay.Again } }) });
            if (dictionary.ContainsKey(ShareManageableCounts.PendingCommentCount))
                list.Add(new ManageableCount { Name = "待审核评论", Value = dictionary[ShareManageableCounts.PendingCommentCount], Url = SPBUrlHelper.Action("ManageShareComments", "ManageShare", new RouteValueDictionary { { "auditingStatusForDisplay", AuditingStatusesForDisplay.Pending } }) });
            list.Add(new ManageableCount { Name = "总分享数", Value = shareApplication.TotalCount });
            return Json(list,JsonRequestBehavior.AllowGet);
        }

    }

    /// <summary>
    /// 管理SubMenu枚举项
    /// </summary>
    public enum ShareSubMenu
    {
        /// <summary>
        /// 分享管理
        /// </summary>
        ManageShare = 26101,
        /// <summary>
        /// 分享评论管理
        /// </summary>
        ManageShareComment = 26102,
        /// <summary>
        /// 标签管理
        /// </summary>
        ManageSiteTags = 26103,
        /// <summary>
        /// 管理站点分类
        /// </summary>
        ManageSiteCategories = 26104,

    }
}
