﻿//<TunynetCopyright>
//--------------------------------------------------------------
//<copyright>拓宇网络科技有限公司 2005-2009</copyright>
//<version>V2.3</verion>
//<createdate>2009-11-4</createdate>
//<author>chenq</author>
//<email>chenq@tunynet.com</email>
//<log date="2009-11-4">创建</log>
//--------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common.Controllers;
using System.Web.Mvc;
using SpaceBuilder.Web;
using System.Web.Routing;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using System.Web.UI;

namespace SpaceBuilder.Share.Controllers
{
    [UserDomainGuideInstallApplication(ApplicationID = 261)]
    [HttpCompress]
    public class UserDomainShareController : UserDomainControllerBase
    {
        private int applicationID = ApplicationIDs.Instance().Share();

        #region Share

        #region View

        /// <summary>
        /// 空间显示我的分享页
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserVisitAndUserDomainHitTime]
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult ListMyUserShareThreads(string userDomainName)
        {
            SetPageTitle(GetResourceString("Title_MyShare", applicationID));
            return View("Pages/Shares/ListMyUserShareThreads.aspx", "Masters/Share.master");
        }

        /// <summary>
        /// 朋友的分享
        /// </summary>
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult ListFriendUserShareThreads(string userDomainName)
        {
            SetPageTitle(GetResourceString("Title_FriendShare", applicationID));
            return View("Pages/Shares/ListFriendUserShareThreads.aspx", "Masters/Share.master");
        }

        /// <summary>
        /// 根据标签显示分享列表
        /// </summary>
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult ListUserShareThreadsByUserTag(string userDomainName, string tagName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            UserTag userTag = UserTagManager.Instance(UserTagItemKeys.Instance().UserShareThread()).GetUserTag(tagName, currentDomainUser.UserID, false);
            if (userTag == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_UserTagNotFound", applicationID), tagName)));
            }
            SetPageTitle(GetResourceString("Common_UserTag") + "：" + userTag.TagName);
            return View("Pages/Shares/ListUserShareThreadsByUserTag.aspx", "Masters/Share.master");
        }

        /// <summary>
        /// 显示创建分享页面
        /// </summary>
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult NewUserShareThread(string userDomainName)
        {
            ShareThread shareThread = TempData.Get<ShareThread>("shareThread", new ShareThread());
            if (string.IsNullOrEmpty(shareThread.URL))
                return Redirect(SiteUrls.Instance().Error(GetResourceString("Exception_ImportAddressToShareHome", applicationID)));

            return View("Pages/Shares/EditUserShareThread.aspx", "Masters/Share.master", new UserShareThread());
        }

        /// <summary>
        /// 显示编辑分享页面
        /// </summary>
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult EditUserShareThread(string userDomainName, int userThreadID)
        {
            UserShareThread userShareThread = UserShareThreads.GetThread(userThreadID, true);
            return View("Pages/Shares/EditUserShareThread.aspx", "Masters/Share.master", userShareThread);
        }

        /// <summary>
        /// 显示用户分享页
        /// </summary>
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult ShowUserShareThread(string userDomainName, int userThreadID)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            UserShareThread userShareThread = UserShareThreads.GetThread(userThreadID, HasManagePermission(currentDomainUser));
            if (userShareThread == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_FileNotFound", applicationID), userThreadID)));
            }
            if (HasManagePermission(userDomainName))
                ViewData["hasManagePermission"] = true;

            SetPageTitle(userDomainName, "显示分享");

            #region 处理审核
            int auditingStatusValue = (int)Applications.GetApplication(ApplicationIDs.Instance().Share()).AuditingStatusForPublicDisplay;
            if ((int)userShareThread.SiteShareThread.AuditingStatus < auditingStatusValue)
            {
                if (userShareThread.SiteShareThread.AuditingStatus == AuditingStatuses.Fail)
                    ViewData["errorMessage"] = GetResourceString("Message_ShareWithoutAuditing", applicationID);
                else
                    ViewData["errorMessage"] = GetResourceString("Message_ShareAuditing", applicationID);
                ViewData["errorAuditingStatus"] = true;
            }
            #endregion

            #region 处理隐私
            PrivacyStatuses? errorPrivacyStatus = null;
            switch (userShareThread.PrivacyStatus)
            {
                case PrivacyStatuses.NeedPassword:
                    // 需要密码
                    string getPassword = Request.QueryString.GetString("password", string.Empty);
                    if (userShareThread.Password.ToLower() != getPassword.ToLower())
                    {
                        ViewData["errorMessage"] = GetResourceString("Message_PassWordError", applicationID);
                        errorPrivacyStatus = PrivacyStatuses.NeedPassword;
                    }
                    break;
                case PrivacyStatuses.OnlyFriend:
                    //仅朋友可见
                    if (!Friends.IsFriend(CurrentUser == null ? 0 : CurrentUser.UserID, currentDomainUser.UserID))
                        errorPrivacyStatus = PrivacyStatuses.OnlyFriend;
                    break;
                case PrivacyStatuses.Privacy:
                    // 私密
                    errorPrivacyStatus = PrivacyStatuses.Privacy;
                    break;
                case PrivacyStatuses.Public:
                    // 公开
                    break;
                default:
                    break;
            }
            ViewData["errorPrivacyStatus"] = errorPrivacyStatus;
            #endregion

            #region 计数 标题
            AddWebCount<ShareThreadCounter>(userShareThread.ThreadID);
            SetPageTitle(userDomainName, userShareThread.SiteShareThread.Subject);
            #endregion

            #region 设置Meta标签
            string metaDescription = string.Empty;
            metaDescription = string.Format("{0}：{1}", userShareThread.SiteShareThread.Subject, StringUtils.Trim(userShareThread.SiteShareThread.Body, 150));
            Header.AddMetaKeywords(userShareThread.SiteShareThread.Subject);
            Header.AddMetaDescription(metaDescription);
            #endregion

            if (userShareThread.SiteShareThread.MediaType == MediaTypes.Website)
                return View("Pages/Shares/ShowShareLink.aspx", userShareThread);
            else
                return View("Pages/Shares/ShowUserShareThread.aspx", "Masters/Share.master", userShareThread);
        }

        /// <summary>
        /// 管理用户分享标签
        /// </summary>
        /// <param name="userDomainName">当前空间用户用户名</param>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult ManageShareUserTags(string userDomainName)
        {
            #region 计数 标题
            SetPageTitle(userDomainName, GetResourceString("Title_ManageShareTag", applicationID));
            #endregion
            return View("Pages/Shares/ManageShareUserTags.aspx", "Masters/Share.master");
        }

        #endregion

        #region Control

        /// <summary>
        /// 显示用户分享列表控件
        /// </summary>
        [OutputCache(Location = OutputCacheLocation.None)]
        public ActionResult Control_ListUserShareThreads(string userDomainName, MediaTypes? mediaType, int? applicationID, string tagName, bool? isFriended, int? pageIndex)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            PagingDataSet<UserShareThread> pds = null;
            if (isFriended ?? false)
                pds = UserShareThreads.GetFriendThreads(currentDomainUser.UserID, mediaType, applicationID, pageIndex ?? 1);
            else
            {
                if (HasManagePermission(userDomainName))
                {
                    pds = UserShareThreads.GetMyThreads(currentDomainUser.UserID, mediaType, applicationID, tagName, pageIndex ?? 1);
                }
                else
                {
                    if (Friends.IsFriend(CurrentUser == null ? 0 : CurrentUser.UserID, currentDomainUser.UserID))
                        pds = UserShareThreads.GetUserThreads(currentDomainUser.UserID, mediaType, applicationID, tagName, PrivacyStatusesForDisplay.NeedPassword_GreaterThanOrEqual, pageIndex ?? 1);
                    else
                        pds = UserShareThreads.GetUserThreads(currentDomainUser.UserID, mediaType, applicationID, tagName, PrivacyStatusesForDisplay.Public, pageIndex ?? 1);
                }
            }
            ViewData["hasManagePermission"] = HasManagePermission(userDomainName);
            ViewData["mediaType"] = (int?)mediaType;
            ViewData["applicationID"] = applicationID;
            ViewData["isFriended"] = isFriended;
            ViewData["tagName"] = tagName;
            return PartialView("Controls/Shares/ListUserShareThreads.ascx", pds);
        }

        /// <summary>
        /// 用户分享用户标签
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult Control_ListShareUserTags(string userDomainName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            ICollection<UserTag> userTags = UserTagManager.Instance(UserTagItemKeys.Instance().UserShareThread()).GetUserTags(currentDomainUser.UserID, false);
            ViewData["hasManagePermission"] = HasManagePermission(userDomainName);
            return PartialView("Controls/Shares/ListShareUserTags.ascx", userTags);
        }

        /// <summary>
        ///用户其他分享视频 
        /// </summary>
        /// <param name="userDomainName"></param>
        /// <param name="shareCategoryID"></param>
        /// <param name="applicationID"></param>
        /// <returns></returns>
        public ActionResult Control_UserShareThreadsBlock(string userDomainName, MediaTypes? mediaType, int? applicationID, int? disPlayCount)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            ViewData["userID"] = currentDomainUser.UserID;
            ViewData["mediaType"] = mediaType.HasValue ? (int)mediaType : (int)MediaTypes.Video;

            PrivacyStatusesForDisplay privacyStatusesForDisplay = Friends.IsFriend(CurrentUser == null ? 0 : CurrentUser.UserID, currentDomainUser.UserID) ? PrivacyStatusesForDisplay.NeedPassword_GreaterThanOrEqual : PrivacyStatusesForDisplay.Public;
            PagingDataSet<UserShareThread> pds = UserShareThreads.GetUserThreads(currentDomainUser.UserID, mediaType, applicationID, string.Empty, privacyStatusesForDisplay, 1);
            return PartialView("Controls/Shares/UserShareThreadsBlock.ascx", pds);
        }

        /// <summary>
        /// 人脉关系：最近分享此视频的好友和最近分享此视频的会员
        /// </summary>
        public ActionResult Control_Relations(string userDomainName, int userID, int threadID, int? disPlayCount)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            UserShareThread userShareThread = UserShareThreads.GetThread(currentDomainUser.UserID, threadID, false);

            if (userShareThread == null)
                return new EmptyResult();

            ViewData["userID"] = currentDomainUser.UserID;
            ViewData["threadID"] = threadID;
            ViewData["MediaType"] = userShareThread.SiteShareThread.MediaType;
            PagingDataSet<UserShareThread> shareThreads = UserShareThreads.GetFriendThreads(currentDomainUser.UserID, userShareThread.SiteShareThread.MediaType, null, 1);
            IList<UserShareThread> friendsShareThreads = new List<UserShareThread>();

            foreach (UserShareThread friendShareThread in shareThreads.Records)
            {
                if (friendShareThread.ThreadID == threadID)
                    friendsShareThreads.Add(friendShareThread);
            }
            ViewData["friendsShareThreads"] = friendsShareThreads;

            IList<UserShareThread> userShareThreads = UserShareThreads.GetUserThreadsByThreadID(threadID);
            return PartialView("Controls/Shares/Relations.ascx", userShareThreads);
        }

        /// <summary>
        /// 空间分享输入框
        /// </summary>
        /// <param name="userDomainName"></param>
        /// <returns></returns>
        public ActionResult Control_ShareInput(string userDomainName)
        {
            return PartialView("Controls/Shares/ShareInput.ascx");
        }

        #endregion

        #region Operation

        /// <summary>
        /// 创建站点分享
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult CreateShareThread(string userDomainName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            string url = Request.Form.GetString("urlForShare", string.Empty);
            if (string.IsNullOrEmpty(url))
            {
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Hint, GetResourceString("Validate_LinkNotEmpty", applicationID));
                return RedirectToAction("ListMyUserShareThreads", new RouteValueDictionary { { "userDomainName", userDomainName } });
            }
            int threadID = 0;
            ShareThread shareThread = null;
            if (ShareThreads.UrlIsExist(url, out threadID))
            {
                if (threadID > 0)
                {
                    shareThread = ShareThreads.GetThread(threadID, true);
                    if (shareThread != null)
                    {
                        UserShareThread userShareThread = UserShareThreads.GetThread(CurrentUser.UserID, shareThread.ThreadID, true);
                        if (userShareThread != null)
                        {
                            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Hint, GetResourceString("Message_EditShareLink", applicationID));
                            return RedirectToAction("EditUserShareThread", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userThreadID", userShareThread.UserThreadID } });
                        }
                        else
                            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Hint, GetResourceString("Message_AddShareLink", applicationID));
                    }
                }
            }
            else
            {
                shareThread = new ShareThread(UrlParserFactory.Instance().ParseUrl(url));
                shareThread.UserID = CurrentUser.UserID;
                shareThread.Author = CurrentUser.DisplayName;
                shareThread.Subject = Formatter.FormatSingleLinePlainTextForStorage(shareThread.Subject);
                shareThread.Body = Formatter.FormatMultiLinePlainTextForStorage(shareThread.Body, true);
            }
            TempData["shareThread"] = shareThread;
            return RedirectToAction("NewUserShareThread", new RouteValueDictionary { { "userDomainName", userDomainName } });
        }

        /// <summary>
        /// 在空间中处理创建更新用户分享
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult CreateUpdateUserShareThread(string userDomainName, int threadID, int? userThreadID)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            StatusMessageData statusMessageData = null;
            UserShareThread userShareThread = null;
            ShareThread shareThread = null;
            if (userThreadID.HasValue && userThreadID.Value > 0)
            {
                userShareThread = UserShareThreads.GetThread(userThreadID.Value, true);
                if (userShareThread == null)
                    return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_UserShareNotFound", applicationID), userThreadID.Value)));
                shareThread = userShareThread.SiteShareThread;
            }
            else
            {
                userShareThread = new UserShareThread();
                userShareThread.UserID = CurrentUser.UserID;
                userShareThread.Author = CurrentUser.DisplayName;
                if (threadID > 0)
                    shareThread = ShareThreads.GetThread(threadID, true);
                if (shareThread == null)
                {
                    shareThread = new ShareThread();
                    shareThread.UserID = CurrentUser.UserID;
                    shareThread.Author = CurrentUser.DisplayName;
                    shareThread.URL = Request.Form.GetString("url", shareThread.URL);
                }
            }

            userShareThread.Body = Request.Form.GetString("commentBody", string.Empty).Trim();
            userShareThread.PrivacyStatus = (PrivacyStatuses)Request.Form.GetInt("privacyStatus", (int)userShareThread.PrivacyStatus);
            if (userShareThread.PrivacyStatus == PrivacyStatuses.NeedPassword)
                userShareThread.Password = Request.Form.GetString("privacyStatus_Password", userShareThread.Password);

            //处理标签
            List<UserTag> selectedTags = null;
            string selectedTagNames = Request.Form.GetString("userTags", string.Empty);
            if (!string.IsNullOrEmpty(selectedTagNames))
            {
                string[] tagNames = selectedTagNames.Split(UserTagManager.SplitCharacters, StringSplitOptions.RemoveEmptyEntries);
                if (tagNames != null && tagNames.Length > 0)
                {
                    selectedTags = new List<UserTag>();
                    foreach (string tagName in tagNames)
                    {
                        if (!string.IsNullOrEmpty(tagName.Trim()))
                        {
                            UserTag userTag = UserTagManager.Instance(UserTagItemKeys.Instance().UserShareThread()).GetUserTag(tagName, currentDomainUser.UserID, true);
                            if (userTag == null)
                            {
                                userTag = new UserTag();
                                userTag.UserID = currentDomainUser.UserID;
                                userTag.TagName = StringUtils.Trim(tagName, 8, string.Empty);
                                bool isCreated = UserTagManager.Instance(UserTagItemKeys.Instance().UserShareThread()).CreateUserTag(userTag);
                                if (!isCreated)
                                    continue;
                            }
                            selectedTags.Add(userTag);
                        }
                    }
                }
            }
            // 首次收藏，或者具有编辑站点分享权限对站点分享进行更新
            if (shareThread.ThreadID <= 0 || shareThread.UserID == CurrentUser.UserID || HasManagePermission(userDomainName))
            {
                //站点分享的隐私设置与站点分享的首位分享人的用户分享中隐私设置相同
                shareThread.PrivacyStatus = userShareThread.PrivacyStatus;
                shareThread.Body = Request.Form.GetString("body", shareThread.Body);
                shareThread.Subject = Request.Form.GetString("subject", shareThread.Subject);
                shareThread.ThumbnailUrl = Request.Form.GetString("thumbnailUrl", shareThread.ThumbnailUrl);
                if (ShareConfiguration.Instance().EableUserEntrySiteCategory)
                    shareThread.SiteCategoryID = Request.Form.GetInt("ShareSiteCategoryDDL", shareThread.SiteCategoryID);
                shareThread.MediaType = (MediaTypes)Request.Form.Get<int>("mediaType", (int)shareThread.MediaType);
                shareThread.PlayerUrl = Request.Form.GetString("playerUrl", shareThread.PlayerUrl);
                if (shareThread.ThreadID > 0)
                    ShareThreads.UpdateThread(shareThread);
                else
                {
                    ShareThreads.CreateThread(shareThread);
                    if (shareThread.ThreadID <= 0)
                        statusMessageData = new StatusMessageData(StatusMessageType.Error, GetResourceString("Message_CreateShareAborted", applicationID));
                }
            }

            if (userThreadID.HasValue && userThreadID.Value > 0)  //更新
            {
                UserShareThreads.UpdateThread(userShareThread, selectedTags);
                if (selectedTags != null && selectedTags.Count > 0)
                {
                    UserTagManager.Instance(UserTagItemKeys.Instance().UserShareThread()).UpdateUserTagsOfItem(userShareThread.UserThreadID, CurrentUser.UserID, selectedTags.Select(n => n.TagName).ToList());
                }
                statusMessageData = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_UpdateShareSucceed", applicationID));
            }
            else   //添加用户分享
            {
                if (shareThread.ThreadID <= 0)//如果添加站点分享成功
                {
                    statusMessageData = new StatusMessageData(StatusMessageType.Error, GetResourceString("Message_CreateShareAborted", applicationID));
                    TempData["userShareThread"] = userShareThread;
                }
                else if (!UserShareThreads.IsShared(userShareThread.UserID, shareThread.ThreadID))//如果不是重复提交的表单，则添加
                {
                    userShareThread.ThreadID = shareThread.ThreadID;
                    UserShareThreads.CreateThread(userShareThread, selectedTags);
                    if (userShareThread.UserThreadID > 0)
                    {
                        statusMessageData = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_AddShareSucceed", applicationID));
                        if (selectedTags != null && selectedTags.Count > 0)
                        {
                            UserTagManager.Instance(UserTagItemKeys.Instance().UserShareThread()).UpdateUserTagsOfItem(userShareThread.UserThreadID, CurrentUser.UserID, selectedTags.Select(n => n.TagName).ToList());
                        }
                    }
                    else
                    {
                        statusMessageData = new StatusMessageData(StatusMessageType.Error, GetResourceString("Message_AddShareAborted", applicationID));
                        TempData["userShareThread"] = userShareThread;
                    }
                }
            }
            TempData["StatusMessageData"] = statusMessageData;
            if (statusMessageData != null && statusMessageData.MessageType != StatusMessageType.Error)
            {
                return RedirectToAction("ListMyUserShareThreads", new RouteValueDictionary { { "userDomainName", userDomainName } });
            }
            else
            {
                TempData["shareThread"] = shareThread;
                TempData["userShareThread"] = userShareThread;
                return RedirectToAction("NewUserShareThread", new RouteValueDictionary { { "userDomainName", userDomainName } });
            }
        }

        /// <summary>
        /// 删除用户分享
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult DeleteUserShareThread(string userDomainName, int userThreadID, int? mediaType, int? applicationID, string tagName, bool isFriended, int? pageIndex)
        {
            ExecDeleteUserShareThread(userDomainName, userThreadID);
            return RedirectToAction("Control_ListUserShareThreads", new RouteValueDictionary { { "userDomainName", userDomainName }, { "mediaType", mediaType }, { "applicationID", applicationID }, { "tagName", tagName }, { "isFriended", isFriended }, { "pageIndex", pageIndex } });
        }

        /// <summary>
        /// 详细显示页删除用户分享
        /// </summary>
        public ActionResult DeleteUserShareThreadForShow(string userDomainName, int userThreadID)
        {
            ExecDeleteUserShareThread(userDomainName, userThreadID);
            return RedirectToAction("ListMyUserShareThreads", new RouteValueDictionary { { "userDomainName", userDomainName } });
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="userDomainName"></param>
        /// <param name="userThreadID"></param>
        private void ExecDeleteUserShareThread(string userDomainName, int userThreadID)
        {
            UserShareThread thread = UserShareThreads.GetThread(userThreadID, true);
            if (thread == null)
                throw new ArgumentException(string.Format(GetResourceString("Exception_Pattern_UserShareNotFound", applicationID), userThreadID));
            if (CurrentUser != null && (thread.UserID == CurrentUser.UserID || CurrentUser.IsContentAdministrator || CurrentUser.IsAdministrator))
            {
                UserShareThreads.DeleteThread(userThreadID);
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_DeleteShareSucceed", applicationID));
            }
            else
            {
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Error, GetResourceString("Message_DeleteShareDenied", applicationID));
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="threadid"></param>
        /// <param name="userDomainName"></param>
        /// <param name="userThreadID"></param>
        /// <returns></returns>
        public ActionResult updateUserShareThread(int threadid, string userDomainName, int userThreadID)
        {
            List<int> threadId = new List<int>();
            threadId.Add(threadid);
            ShareThreads.UpdateAuditingStatus(threadId, AuditingStatuses.Success);
            return RedirectToAction("ShowUserShareThread", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userThreadID", userThreadID } });
        }

        /// <summary>
        /// 分享给好友
        /// </summary>
        /// <param name="userDomainName"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult ShareToFriends(string userDomainName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            string[] receivers;
            string receiverIDs = Request.Form["receiverIDs"];
            string title = Request.Form.GetString("Title", string.Empty);
            string commentBody = Request.Form.GetString("commentBody", string.Empty);
            string subject = Request.Form.GetString("subject", string.Empty);
            int threadID = Request.Form.GetInt("threadID", 0);
            string body = Request.Form.GetString("body", string.Empty);
            string url = Request.Form.GetString("url", string.Empty);
            if (threadID > 0)
                url = SiteUrls.Instance().ShowShareThread(threadID);

            string messageContent = string.Empty;
            StatusMessageType statusType = StatusMessageType.Error;
            if (string.IsNullOrEmpty(title))
                title = subject;

            if (string.IsNullOrEmpty(receiverIDs) || string.IsNullOrEmpty(title) || string.IsNullOrEmpty(body))
            {
                TempData["Title"] = title;
                TempData["body"] = body;
                if (string.IsNullOrEmpty(receiverIDs))
                    messageContent = GetResourceString("Message_SendErrorForReceiverEmpty", applicationID);
                else if (string.IsNullOrEmpty(title))
                    messageContent = GetResourceString("Message_SendErrorForSubjectEmpty", applicationID);
                else
                    messageContent = GetResourceString("Message_SendErrorForBodyEmpty", applicationID);
            }

            //收件人集合
            receivers = receiverIDs.Split(',');
            //每个消息最多允许100个接收人
            if (receivers.Length > 100)
            {
                messageContent = GetResourceString("Message_SendErrorForBeyondMaxPersonCount", applicationID);
                return RedirectToAction("Control_ShareInModal", "ChannelShare", CurrentRouteValueDictionary);
            }
            //发送私信成功的接收人集合
            List<string> successReceivers = new List<string>();
            int toUserID = -1;
            //为每个收件人建立私信
            for (int i = 0; i < receivers.Length; i++)
            {
                //查找收件人
                User user = null;

                if (int.TryParse(receivers[i], out toUserID))
                {
                    user = Users.GetUser(toUserID, false);
                }

                if (user == null)
                    continue;
                //判断当前空间者是否接受访问者的私信
                if (CurrentUser != null && Privacys.Validate(user.UserID, CurrentUser, PrivacyItemKeys.Instance().Action_ReceivePrivateMessage()))
                {
                    PrivateMessage pm = new PrivateMessage();
                    pm.Subject = title;
                    pm.Body = body;
                    pm.SenderUserID = CurrentUser.UserID;
                    pm.Sender = CurrentUser.DisplayName;
                    pm.MessageType = PrivateMessageType.Common;

                    pm.ReceiverUserID = user.UserID;
                    pm.Receiver = user.DisplayName;

                    #region 格式化处理
                    pm.Subject = Formatter.FormatSingleLinePlainTextForStorage(pm.Subject);
                    pm.Body = Formatter.FormatMultiLinePlainTextForStorage(pm.Body, true);

                    if (SPBConfig.Instance().EnableEmoticon)
                        pm.Body = EmotionManager.Instance().EmoticonTransforms(pm.Body);
                    commentBody = Formatter.FormatMultiLinePlainTextForStorage(commentBody, true);
                    pm.Body = string.Format("{4}{5}<a href=\"{0}\">{1}</a><br/><p>{2}</p><br/>{3}", url, subject, pm.Body, commentBody, GetResourceString("Label_Share", applicationID), GetResourceString("Common_Colon"));

                    #endregion

                    PrivateMessages.SendMessage(pm);
                    successReceivers.Add(user.DisplayName);
                    toUserID = user.UserID;
                }

            }
            //如果有成功发送的消息则显示提示信息
            if (successReceivers.Count > 0)
            {
                statusType = StatusMessageType.Success;
                string strReceivers = string.Empty;
                foreach (string displayName in successReceivers)
                {
                    strReceivers += "," + displayName;
                }
                messageContent = string.Format(GetResourceString("Message_Pattern_SendSuccess", applicationID), strReceivers.Substring(1));
            }
            else
            {
                messageContent = GetResourceString("Message_SendErrorForOther", applicationID);
            }

            TempData["StatusMessageData"] = new StatusMessageData(statusType, messageContent);

            if (toUserID > 0)
                return RedirectToAction("Control_ShareInModal", "ChannelShare", CurrentRouteValueDictionary);
            else
                return RedirectToAction("Control_ShareInModal", "ChannelShare", CurrentRouteValueDictionary);
        }

        #endregion

        #endregion

        #region Comment

        #region View

        /// <summary>
        /// 管理评论
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult ManageComments(string userDomainName, int? pageIndex)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            PagingDataSet<ShareComment> pds = ShareComments.GetMyShareComments(currentDomainUser.UserID, pageIndex ?? 1);
            return View("Pages/Shares/ManageComments.aspx", "Masters/Share.Master", pds);
        }

        #endregion

        #region Control

        /// <summary>
        /// 评论列表
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        [OutputCache(Location = OutputCacheLocation.None)]
        public ActionResult Control_ListUserShareComments(string userDomainName, string controlName, int userShareThreadID, int? pageIndex)
        {
            UserShareThread shareThread = UserShareThreads.GetThread(userShareThreadID, false);
            if (shareThread == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ShareNotFound", applicationID), userShareThreadID)));
            }
            PagingDataSet<ShareComment> pds = ShareComments.GetCommentsOfThread(shareThread.ThreadID, shareThread.UserThreadID, pageIndex ?? 1, HasManagePermission(userDomainName));
            return PartialView(string.Format("Controls/Shares/{0}.ascx", string.IsNullOrEmpty(controlName) ? "ListUserShareComments" : controlName), pds);
        }

        #endregion

        #region Operation

        /// <summary>
        /// 创建分享评论
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult CreateShareComment(string userDomainName, string controlName, int userShareThreadID, int? pageIndex)
        {

            if (!SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting && CurrentUser == null)
                return Redirect(SiteUrls.Instance().Error("你没有评论的权限!"));

            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            SiteSettings settings = SiteSettingsManager.GetSiteSettings();
            if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
            {
                string verifyCodeFromCookie = Globals.GetVerifyCodeFromCookie(this.HttpContext);
                string verifyCode = Request.Form.GetString("verifyCode", string.Empty);
                TempData["parentID"] = Request.Form.GetInt("parentID", 0);
                if (verifyCode != null)
                {
                    verifyCode = verifyCode.Trim();
                }
                if (!verifyCode.Equals(verifyCodeFromCookie, StringComparison.CurrentCultureIgnoreCase))
                {
                    TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                    TempData["StatusMessageContent"] = GetResourceString("Validate_ValidateInformationError", applicationID);
                    TempData["commentBody"] = Request.Form.GetString("commentBody", string.Empty).Trim();
                    return RedirectToAction("Control_ListUserShareComments", CurrentRouteValueDictionary);
                }
            }
            UserShareThread shareThread = UserShareThreads.GetThread(userShareThreadID, false);
            if (shareThread == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format("ID：“{0}”{1}", userShareThreadID, GetResourceString("Message_ShareNotFound", applicationID))));
            }
            ShareComment shareComment = new ShareComment();
            shareComment.ThreadID = shareThread.ThreadID;
            shareComment.Body = Request.Form.GetString("commentBody", string.Empty).Trim();
            shareComment.UserThreadID = userShareThreadID;
            shareComment.Author = CurrentUser == null ? "匿名用户" : CurrentUser.DisplayName;
            shareComment.UserID = CurrentUser == null ? 0 : CurrentUser.UserID;
            shareComment.ParentID = Request.Form.GetInt("parentID", 0);
            shareComment.OwnerUserID = currentDomainUser.UserID;

            if (shareComment.ParentID > 0)
            {
                ShareComment parentCommet = ShareComments.GetComment(shareComment.ParentID, true);
                if (parentCommet != null)
                {
                    shareComment.ParentAuthor = parentCommet.Author;
                    shareComment.ParentBody = parentCommet.Body;
                    shareComment.ParentUserID = parentCommet.UserID;
                    if (shareComment.Body.StartsWith(string.Format("{0}{1}：", GetResourceString("Common_Reply"), parentCommet.Author), StringComparison.CurrentCultureIgnoreCase))
                    {
                        if (shareComment.Body.Length > string.Format("{0}{1}：", GetResourceString("Common_Reply"), parentCommet.Author).Length)
                        {
                            shareComment.Body = shareComment.Body.Substring(string.Format("{0}{1}：", GetResourceString("Common_Reply"), parentCommet.Author).Length);
                        }
                        else
                        {
                            TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                            TempData["StatusMessageContent"] = GetResourceString("Message_ImportReversion", applicationID);
                            TempData["commentBody"] = shareComment.Body;
                            TempData["parentID"] = shareComment.ParentID;
                            return RedirectToAction("Control_ListUserShareComments", CurrentRouteValueDictionary);
                        }
                    }
                }
            }
            try
            {
                ShareComments.CreateComment(shareComment);
            }
            catch (SPBException e)
            {
                ExceptionMessage exceptionMessage = ResourceManager.GetExceptionMessage(e.ExceptionType, ApplicationIDs.Instance().Share());
                if (exceptionMessage != null)
                {
                    TempData["StatusMessageType"] = StatusMessageType.Error;
                    TempData["StatusMessageContent"] = exceptionMessage.Title + "，" + exceptionMessage.Body;
                }
                return RedirectToAction("Control_ListUserShareComments", CurrentRouteValueDictionary);
            }
            if ((int)shareComment.AuditingStatus >= (int)SiteSettingsManager.GetSiteSettings().AuditingStatusesForPublicDisplay)
            {
                TempData["StatusMessageContent"] = GetResourceString("Message_AddCommontSucceed", applicationID);
            }
            else
            {
                TempData["StatusMessageContent"] = GetResourceString("Message_DescryAfterAuditin", applicationID);
            }
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            ViewData["ShareThread"] = shareThread;
            return RedirectToAction("Control_ListUserShareComments", CurrentRouteValueDictionary);
        }

        /// <summary>
        /// 删除分享评论
        /// </summary>
        public ActionResult DeleteShareComment(int commentID, string userDomainName, string controlName, int userShareThreadID, int? pageIndex)
        {
            RouteValueDictionary dictionary = new RouteValueDictionary { { "userDomainName", userDomainName }, { "userShareThreadID", userShareThreadID }, { "controlName", controlName }, { "pageIndex", pageIndex } };
            ShareComment comment = ShareComments.GetComment(commentID, true);
            if (comment == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_CommentNotFound", applicationID), commentID)));
            }
            UserShareThread shareThread = UserShareThreads.GetThread(comment.UserThreadID, false);
            if (shareThread == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ShareNotFound", applicationID), comment.ThreadID)));
            }
            if (CurrentUser != null && comment.UserID != CurrentUser.UserID && !HasManagePermission(userDomainName))
                throw new SPBException(ExceptionTypes.Instance().AccessDenied());

            ShareComments.DeleteComment(commentID);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = GetResourceString("Message_DeleteSucceed", applicationID);
            return RedirectToAction("Control_ListUserShareComments", new RouteValueDictionary(dictionary));
        }

        /// <summary>
        /// 删除单个评论
        /// </summary>
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult DeleteCommentInManage(int commentID, string returnUrl)
        {
            ShareComment comment = ShareComments.GetComment(commentID, true);
            if (comment == null)
            {
                throw new ArgumentException(string.Format(GetResourceString("Exception_Pattern_CommentOFCommentIDNotFound", applicationID), commentID));
            }
            if (CurrentUser != null && (CurrentUser.UserID == comment.UserID || CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator))
            {
                ShareComments.DeleteComment(commentID);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = GetResourceString("Message_DeleteCommontSucceed", applicationID);
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_DeleteCommentAborted", applicationID);
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 管理评论页，批量删除评论
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult DeleteComments(string userDomainName, string returnUrl)
        {
            User ownerUser = GetCurrentDomainUser(userDomainName);

            string selectIDsString = Request.Form["ManageCommentsCheckBoxGroup"];
            int commentID = 0;
            if (!string.IsNullOrEmpty(selectIDsString))
            {
                string[] selectIDsStringArray = selectIDsString.Split(',');
                if (CurrentUser != null && selectIDsStringArray != null && selectIDsStringArray.Length > 0 && (ownerUser.UserID == CurrentUser.UserID || CurrentUser.IsContentAdministrator || CurrentUser.IsAdministrator))
                {
                    foreach (string idString in selectIDsStringArray)
                    {
                        commentID = int.Parse(idString);
                        ShareComments.DeleteComment(commentID);
                    }
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = GetResourceString("Message_DeleteCommontSucceed", applicationID);
                }
                else
                {
                    TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                    TempData["StatusMessageContent"] = GetResourceString("Message_DeleteDenied", applicationID);
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_ChooseDeletingComment", applicationID);
            }
            return Redirect(returnUrl);
        }

        #endregion

        #endregion

    }

    /// <summary>
    /// 空间分享二级菜单
    /// </summary>
    public enum ShareUserDomainSubMenus
    {
        //我发起的投票
        myCreated = 1,
        //我朋友的投票
        myFriend = 2
    }
}