﻿//<TunynetCopyright>
//--------------------------------------------------------------
//<copyright>拓宇网络科技有限公司 2005-2009</copyright>
//<version>V2.3</verion>
//<createdate>2009-11-4</createdate>
//<author>chenq</author>
//<email>chenq@tunynet.com</email>
//<log date="2009-11-4">创建</log>
//--------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Web;

namespace SpaceBuilder.Share.Modules
{
    public class DisposeActivityForShare : IShareModule
    {

        #region IShareModule 成员

        public void Init(ShareEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterShareCommentChange += new ShareCommentEventHandler(em_AfterShareCommentChange);
            em.AfterUserShareThreadChange += new UserShareThreadEventHandler(em_AfterUserShareThreadChange);
        }

        void em_AfterUserShareThreadChange(UserShareThread userShareThread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewUserShareThread();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;
                User user = Users.GetUser(userShareThread.UserID, false);

                if (user == null)
                    return;

                #region 处理个人动态
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;

                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewUserShareThread", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), userShareThread.SiteShareThread.GetMultilingualShareTypeName(user.Language), GetUserShareNameWithHyperlink(userShareThread));
                userActivity.IsPublic = userShareThread.PrivacyStatus == PrivacyStatuses.Public ? true : false;
                userActivity.RelativeItemID = userShareThread.ThreadID;
                userActivity.RelativeItemName = userShareThread.SiteShareThread.Subject;

                Activities.CreateUserActivity(userActivity);
                #endregion

                #region 处理朋友动态
                if (userShareThread.PrivacyStatus == PrivacyStatuses.Public)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //判断用户是否允许发送给朋友动态项目

                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;

                        friendActivity.RelativeItemID = userShareThread.ThreadID;
                        friendActivity.RelativeItemName = userShareThread.SiteShareThread.Subject;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion
            }
        }

        void em_AfterShareCommentChange(ShareComment shareComment, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewShareComment();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;
                User user = Users.GetUser(shareComment.UserID, false);
                if (user == null)
                    return;
                User toUser = null;
                ShareThread shareThread = ShareThreads.GetThread(shareComment.ThreadID, false);
                if (shareThread == null)
                    return;
                UserShareThread userShareThread = null;
                if (shareComment.UserThreadID > 0)
                {
                    userShareThread = UserShareThreads.GetThread(shareComment.UserThreadID, false);
                    if (userShareThread == null)
                        return;
                    toUser = Users.GetUser(userShareThread.UserID, false);
                }
                if (toUser == null)
                    return;

                #region 处理个人动态
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                if (toUser != null && userShareThread != null)
                {
                    userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewUserShareComment", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true),
                    SPBHtmlHelper.Instance().UserDisplayNameLink(toUser,true),
                     GetUserShareNameWithHyperlink(userShareThread));
                    if (userShareThread != null)
                        userActivity.IsPublic = userShareThread.PrivacyStatus == PrivacyStatuses.Public ? true : false;
                    else
                        userActivity.IsPublic = true;
                }
                else
                {
                    userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewShareComment", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true),
                     GetShareNameWithHyperlink(shareThread));
                    userActivity.IsPublic = true;
                }
                userActivity.RelativeItemID = shareThread.ThreadID;
                userActivity.RelativeItemName = shareThread.Subject;

                Activities.CreateUserActivity(userActivity);
                #endregion

                #region 处理朋友动态
                if (userShareThread != null && userShareThread.PrivacyStatus != PrivacyStatuses.Privacy)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //判断用户是否允许发送给 朋友动态项目

                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion
            }
        }
        #endregion
        /// <summary>
        /// 获取带链接的用户分享名称的html代码
        /// </summary>
        private static string GetUserShareNameWithHyperlink(UserShareThread userShareThread)
        {
            string userShareThreadUrl = SiteUrls.Instance().ShowUserShareThread(UserID2UserNameDictionary.GetUserName(userShareThread.UserID), userShareThread);
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, userShareThreadUrl, userShareThread.SiteShareThread.Subject);
        }
        /// <summary>
        /// 获取带链接的分享名称的html代码
        /// </summary>
        private static string GetShareNameWithHyperlink(ShareThread shareThread)
        {
            string shareThreadUrl = SiteUrls.Instance().ShowShareThread(shareThread.ThreadID);
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, shareThreadUrl, shareThread.Subject);
        }
        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;
    }
}