﻿//<TunynetCopyright>
//--------------------------------------------------------------
//<copyright>拓宇网络科技有限公司 2005-2009</copyright>
//<version>V2.3</verion>
//<createdate>2009-11-4</createdate>
//<author>chenq</author>
//<email>chenq@tunynet.com</email>
//<log date="2009-11-4">创建</log>
//--------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Web;

namespace SpaceBuilder.Share.Modules
{
    public class DisposeNoticeForShare : IShareModule
    {

        #region IShareModule 成员

        public void Init(ShareEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterShareCommentChange += new ShareCommentEventHandler(em_AfterShareCommentChange);
        }

        void em_AfterShareCommentChange(ShareComment shareComment, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if ((e.State == ObjectState.Create))
            {
                if (shareComment.UserID == shareComment.OwnerUserID && shareComment.ParentID <= 0)
                    return;
                //通知接收人
                User toUser = null;
                if (shareComment.ParentID > 0)
                {
                    ShareComment parentComment = ShareComments.GetComment(shareComment.ParentID, true);
                    if (parentComment != null)
                        toUser = Users.GetUser(parentComment.UserID, false);
                }
                else
                    toUser = Users.GetUser(shareComment.OwnerUserID, false);
                if (toUser == null)
                    return;
                ShareThread shareThread = ShareThreads.GetThread(shareComment.ThreadID, false);
                if (shareThread == null)
                    return;
                UserShareThread userShareThread = UserShareThreads.GetThread(shareComment.UserThreadID, false);
                if (userShareThread == null)
                {
                    userShareThread = UserShareThreads.GetThread(shareThread.UserID, shareThread.ThreadID, false);
                    if (userShareThread == null)
                        return;
                    if (shareComment.ParentID <= 0)
                        toUser = Users.GetUser(shareThread.UserID, false);
                }
                if (toUser == null)
                    return;
                string itemKey = NoticeItemKeys.Instance().NewShareComment();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;

                NoticeRecord record = new NoticeRecord();
                record.ApplicationID = ApplicationIDs.Instance().Share();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.LeadingActorUserID = shareComment.UserID;
                record.LeadingActor = shareComment.Author;

                if (shareComment.UserID > 0)
                    record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Share());
                record.UserID = toUser.UserID;
                record.Receiver = toUser.DisplayName;
                record.RelativeItemID = shareThread.ThreadID;
                record.RelativeItemName = shareThread.Subject;
                string hyperlink = GetShareCommentSubjectWithHyperlink(shareThread, shareComment);
                if (shareComment.UserThreadID > 0)
                    hyperlink = GetShareCommentSubjectWithHyperlink(userShareThread, shareComment);
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewShareComment", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(shareComment.UserID, shareComment.Author, true), hyperlink);
                if (shareComment.UserThreadID > 0)
                    record.RelativeItemUrl = SiteUrls.Instance().ShowUserShareThread(toUser.UserName, userShareThread.UserThreadID, shareComment.CommentID);
                else
                    record.RelativeItemUrl = SiteUrls.Instance().ShowShareThread(shareComment.ThreadID);
                record.Body = shareComment.Body;
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        #endregion

        /// <summary>
        /// 获取带链接的博客文章或评论的html代码
        /// </summary>
        private static string GetShareCommentSubjectWithHyperlink(UserShareThread userShareThread, ShareComment child)
        {
            if (child != null)
                return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowUserShareThread(UserID2UserNameDictionary.GetUserName(userShareThread.UserID), userShareThread.UserThreadID, child.CommentID), userShareThread.SiteShareThread.Subject);
            else
                return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowUserShareThread(UserID2UserNameDictionary.GetUserName(userShareThread.UserID), userShareThread.UserThreadID), userShareThread.SiteShareThread.Subject);
        }
        /// <summary>
        /// 获取带链接的博客文章或评论的html代码
        /// </summary>
        private static string GetShareCommentSubjectWithHyperlink(ShareThread shareThread, ShareComment child)
        {
            if (child != null)
                return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowShareThread(shareThread.ThreadID, child.CommentID), shareThread.Subject);
            else
                return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ShowShareThread(shareThread.ThreadID), shareThread.Subject);
        }
        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;
    }
}