﻿//<TunynetCopyright>
//--------------------------------------------------------------
//<copyright>拓宇网络科技有限公司 2005-2009</copyright>
//<version>V2.3</verion>
//<createdate>2009-11-4</createdate>
//<author>chenq</author>
//<email>chenq@tunynet.com</email>
//<log date="2009-11-4">创建</log>
//--------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Share.Modules
{
    public class DisposePointForShare : IShareModule
    {

        #region IShareModule 成员

        public void Init(ShareEventManager em, System.Xml.Linq.XElement xElement)
        {
            //em.AfterShareCommentChange += new ShareCommentEventHandler(em_AfterShareCommentChange);
            //em.AfterShareThreadChange += new ShareThreadEventHandler(em_AfterShareThreadChange);
            em.AfterUserShareThreadChange += new UserShareThreadEventHandler(em_AfterUserShareThreadChange);
            em.AfterPointChangeOfShareThread += new PointChangeOfShareThreadHandler(em_AfterPointChangeOfShareThread);
            em.AfterPointChangeOfShareComment += new PointChangeOfShareCommentHandler(em_AfterPointChangeOfShareComment);
        }

        void em_AfterPointChangeOfShareComment(ShareComment comment, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            if ((e.State == ObjectState.Create || e.State == ObjectState.Delete))
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;
                ShareThread shareThread = ShareThreads.GetThread(comment.ThreadID, false);
                if (shareThread == null)
                    return;

                if (userPointDirection == UserPointDirection.Input)
                {
                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateShareComment());
                    if (e.State == ObjectState.Create)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateShareComment", Globals.GetCurrentUserLanguage(), e.ApplicationID), shareThread.Subject);
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_ShareCommentAuditingSuccess", Globals.GetCurrentUserLanguage(), e.ApplicationID), shareThread.Subject);


                }
                else
                {
                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteShareComment());
                    if (e.State == ObjectState.Delete)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteShareComment", Globals.GetCurrentUserLanguage(), e.ApplicationID), HtmlUtils.TrimHtml(comment.Body, 128));
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_ShareCommentAuditingFail", Globals.GetCurrentUserLanguage(), e.ApplicationID), HtmlUtils.TrimHtml(comment.Body, 128));

                }
                if (role == null)
                    return;
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, comment.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                Points.CreateUserPointRecords(records);
            }
        }

        void em_AfterPointChangeOfShareThread(ShareThread thread, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            if ((e.State == ObjectState.Create || e.State == ObjectState.Delete))
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;


                if (userPointDirection == UserPointDirection.Input)
                {

                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateShareThread());
                    if (e.State == ObjectState.Create)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateShareThread", Globals.GetCurrentUserLanguage(), e.ApplicationID), thread.Subject);
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_ShareThreadAuditingSuccess", Globals.GetCurrentUserLanguage(), e.ApplicationID), thread.Subject);
                }
                else
                {
                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteUserShareThread());
                    if (e.State == ObjectState.Delete)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteUserShareThread", Globals.GetCurrentUserLanguage(), e.ApplicationID), thread.Subject);
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_ShareThreadAuditingFail", Globals.GetCurrentUserLanguage(), e.ApplicationID), thread.Subject);
                }


                if (role == null)
                    return;
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, thread.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                Points.CreateUserPointRecords(records);
            }
        }

        void em_AfterUserShareThreadChange(UserShareThread userShareThread, SpaceBuilder.Common.GlobalEventArgs e)
        {

            List<UserPointRecord> records = new List<UserPointRecord>();
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;

            User ownerUser = Users.GetUser(userShareThread.UserID, false);
            if (ownerUser == null)
                return;
            if (e.State == ObjectState.Create)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateUserShareThread());
                userPointRecordDescription = ResourceManager.GetString("Message_AddUserShare", ownerUser.Language, ApplicationIDs.Instance().Share()) + "：" + userShareThread.SiteShareThread.Subject;
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteUserShareThread());
                userPointRecordDescription = ResourceManager.GetString("Message_DeleteUserShare", ownerUser.Language, ApplicationIDs.Instance().Share()) + "：" + userShareThread.SiteShareThread.Subject;
            }
            if (role == null)
                return;
            records = Points.PopulateUserPointRecords(role, userShareThread.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
            Points.CreateUserPointRecords(records);

            //如果站点分享的首位分享人正是当前用户分享的分享人，则应该收回奖励的首位发布站点分享的积分
            if (e.State == ObjectState.Delete && userShareThread.SiteShareThread.UserID == userShareThread.UserID)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteShareThread());
                if (role == null)
                    return;

                userPointRecordDescription = ResourceManager.GetString("首次发布的分享", ownerUser.Language, ApplicationIDs.Instance().Share()) + "：" + userShareThread.SiteShareThread.Subject + ResourceManager.GetString("Message_Deleted", ownerUser.Language, ApplicationIDs.Instance().Share());
                records = Points.PopulateUserPointRecords(role, userShareThread.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                Points.CreateUserPointRecords(records);
            }
        }

        //void em_AfterShareThreadChange(ShareThread shareThread, SpaceBuilder.Common.GlobalEventArgs e)
        //{
        //    if ((e.State == ObjectState.Create || e.State == ObjectState.Delete))
        //    {
        //        List<UserPointRecord> records = new List<UserPointRecord>();
        //        UserPointItemRole role = null;
        //        string userPointRecordDescription = string.Empty;
        //        if (e.State == ObjectState.Create)
        //        {

        //            role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateShareThread());
        //            userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateShareThread", Globals.GetCurrentUserLanguage(), e.ApplicationID), shareThread.Subject);
        //        }
        //        else
        //        {
        //            role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteUserShareThread());
        //            userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteUserShareThread", Globals.GetCurrentUserLanguage(), e.ApplicationID), shareThread.Subject);
        //        }
        //        PopulateUserPointRecords(records, role, shareThread.UserID, userPointRecordDescription);
        //        if (role != null)
        //        {
        //            Points.CreateUserPointRecords(records);
        //        }
        //    }
        //}

        //void em_AfterShareCommentChange(ShareComment shareComment, SpaceBuilder.Common.GlobalEventArgs e)
        //{
        //    if ((e.State == ObjectState.Create || e.State == ObjectState.Delete))
        //    {
        //        List<UserPointRecord> records = new List<UserPointRecord>();
        //        UserPointItemRole role = null;
        //        string userPointRecordDescription = string.Empty;
        //        ShareThread shareThread = ShareThreads.GetThread(shareComment.ThreadID, false);
        //        if (shareThread == null)
        //            return;

        //        if (e.State == ObjectState.Create)
        //        {
        //            role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateShareComment());
        //            userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateShareComment", Globals.GetCurrentUserLanguage(), e.ApplicationID), shareThread.Subject);
        //        }
        //        else
        //        {
        //            role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteShareComment());
        //            userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteShareComment", Globals.GetCurrentUserLanguage(), e.ApplicationID), HtmlUtils.TrimHtml(shareComment.Body, 128));
        //        }
        //        PopulateUserPointRecords(records, role, shareComment.UserID, userPointRecordDescription);
        //        if (role != null)
        //        {
        //            Points.CreateUserPointRecords(records);
        //        }
        //    }
        //}

        #endregion
    }
}