﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.LuceneSearch;
using SpaceBuilder.Share;

namespace SpaceBuilder.Share.Modules
{
    public class PrepareForShareThreadIndexModule : IShareModule
    {
        #region IShareModule 成员

        public void Init(ShareEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterShareThreadChange += new ShareThreadEventHandler(em_AfterShareThreadChange);
        }

        void em_AfterShareThreadChange(ShareThread thread, GlobalEventArgs e)
        {
            if ((thread != null) && (e.State == ObjectState.Create || e.State == ObjectState.Update || e.State == ObjectState.Delete))
            {
                ItemForIndex item = new ItemForIndex();
                item.ItemID = thread.ThreadID;
                item.SearchTypeCode = ShareSearchTypeSettings.CODE;
                item.DataAction = e.State;
                SearchDataProvider.Instance().CreateUpdateDeleteItemForIndex(item, DataProviderAction.Create);
            }
        }

        #endregion

      
    }
}
