﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Share;

namespace SpaceBuilder.LuceneSearch
{
    public class ShareSearchQuery
    {
        /// <summary>
        /// 首位分享人ID
        /// </summary>
        public int UserID = -1;

        /// <summary>
        /// 查询关键字
        /// </summary>
        public string KeyWord = string.Empty;

        /// <summary>
        ///站外分享的类别ID
        /// </summary>
        public int SiteCategoryID = -1;

        /// <summary>
        /// 站外分享媒体类型ID
        /// </summary>
        public MediaTypes? MediaType = null;

        /// <summary>
        /// 应用ID
        /// </summary>
        public int ApplicationID = -1;

        /// <summary>
        /// 当前显示页面页码
        /// </summary>
        private int pageIndex = 1;
        public int PageIndex
        {
            get
            {
                if (pageIndex < 1)
                    return 1;
                else
                    return pageIndex;
            }
            set { pageIndex = value; }
        }

        /// <summary>
        /// 每页显示记录数
        /// </summary>
        public int PageSize = 20;

    }

}
