﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using SpaceBuilder.Share;

namespace SpaceBuilder.LuceneSearch
{
    public class ShareSearchTypeSettings : SearchTypeSettingsBase
    {
        /// <summary>
        /// 搜索类型编码
        /// </summary>
        public static readonly string CODE = "026101";

        public override int ApplicationID
        {
            get { return ApplicationIDs.Instance().Share(); }
        }

        public override string IndexFileDirectory
        {
            get { return ShareSearchManager.rewardIndexFileDirectory; }
        }
        /// <summary>
        /// 初始化索引
        /// </summary>
        /// <param name="indexPath">索引文件路径</param>
        public override void InitializeIndex(string indexPath)
        {
            ShareSearchManager.Instance().InitializeIndex(indexPath);
        }

        private bool isSimulated = false;
        /// <summary>
        /// 没有采用全文检索,仅是伪装成全文检索
        /// </summary>
        public override bool IsSimulated
        {
            get { return isSimulated; }
        }

        /// <summary>
        /// 搜索类型编码
        /// </summary>
        /// <remarks>
        /// 1、SearchCode必须唯一
        /// 2、SearchCode命名规范: {4位ApplicationID,位数不足左侧补零}{2位编码} 
        /// </remarks>
        public override string SearchTypeCode
        {
            get { return CODE; }
        }

        /// <summary>
        /// 搜索入口URL 
        /// </summary>
        public override string SearchAtionUrl
        {
            //Todo:宝生根据需要修改
            get { return SPBUrlHelper.Action("Search", "ChannelShare"); }
        }
    }
}
