﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Tasks;
using SpaceBuilder.Common;
using System.Xml.Linq;
using SpaceBuilder.Share;

namespace SpaceBuilder.LuceneSearch
{
    public class ShareThreadIndexTask : TaskBase
    {
        /// <summary>
        /// 每次更新索引的最大数目
        /// </summary>
        private int count = 1000;

        #region ITask 成员
        public override void ExecuteTask(XElement xElement)
        {
            XAttribute countNode = xElement.Attribute("count");
            if (countNode != null)
            {
                int.TryParse(countNode.Value, out count);
            }
            IndexPosts(count);
        }
        #endregion

        private void IndexPosts(int count)
        {
            SearchDataProvider dp = SearchDataProvider.Instance();
            IList<ItemForIndex> itemsForIndex = dp.GetItemsForIndex(ShareSearchTypeSettings.CODE, count);

            IList<ItemForIndex> createItems = new List<ItemForIndex>();
            IList<ItemForIndex> updateItems = new List<ItemForIndex>();
            IList<ItemForIndex> deleteItems = new List<ItemForIndex>();

            foreach (ItemForIndex item in itemsForIndex)
            {
                if (item.DataAction == ObjectState.Create)
                    createItems.Add(item);
                else if (item.DataAction == ObjectState.Update)
                    updateItems.Add(item);
                else if (item.DataAction == ObjectState.Delete)
                    deleteItems.Add(item);
            }

            ShareSearchManager searchManager = ShareSearchManager.Instance();

            #region Insert

            IList<ShareThread> createPosts = new List<ShareThread>();
            foreach (ItemForIndex item in createItems)
            {
                createPosts.Add(PopulateShareThreadFromItemForIndex(item));
            }

            if (searchManager.Insert(createPosts))
            {
                dp.DeleteItemsForIndex(createItems);
            }
            else
            {
                foreach (ItemForIndex item in createItems)
                {
                    item.DataAction = ObjectState.Update;
                }
                dp.UpdateItemsForIndex(createItems);
            }

            #endregion

            #region Update

            IList<ShareThread> updatePosts = new List<ShareThread>();
            foreach (ItemForIndex item in updateItems)
            {
                updatePosts.Add(PopulateShareThreadFromItemForIndex(item));
            }

            if (searchManager.Update(updatePosts, n => n.Select(m => m.ThreadID).ToList(), ShareIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(updateItems);
            }

            #endregion

            #region Delete
            if (deleteItems.Count > 0 && searchManager.Delete(deleteItems.Select(n => n.ItemID).ToList(), ShareIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(deleteItems);
            }
            #endregion
        }

        private ShareThread PopulateShareThreadFromItemForIndex(ItemForIndex itemForIndex)
        {
            ShareThread thread = ShareThreads.GetThread(itemForIndex.ItemID, true);
            if (thread == null)
                return null;
            return thread;
        }


       
    }
}
