﻿//<TunynetCopyright>
//--------------------------------------------------------------
//<copyright>拓宇网络科技有限公司 2005-2009</copyright>
//<version>V2.3</verion>
//<createdate>2009-11-4</createdate>
//<author>chenq</author>
//<email>chenq@tunynet.com</email>
//<log date="2009-11-4">创建</log>
//--------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Web;
using System.Web.Routing;
using SpaceBuilder.Utils;
using SpaceBuilder.Share;
using SpaceBuilder.Common;

namespace SpaceBuilder.Share
{
    public static class SiteUrlsExtensions
    {
        /// <summary>
        /// 分享频道首页
        /// </summary>
        public static string ChannelShareHome(this SiteUrls siteUrls)
        {
            return SPBUrlHelper.RouteUrl("Channel_Share_Home");
        }
        /// <summary>
        /// 获取站点分享的地址
        /// </summary>
        public static string ShowShareThread(this SiteUrls siteUrls, ShareThread thread)
        {
            if (thread.ApplicationID > 0)
                return thread.URL;
            return SiteUrls.Instance().ShowShareThread(thread.ThreadID);
        }
        /// <summary>
        /// 获取站点站外分享显示的URL
        /// </summary>
        /// <returns></returns>
        public static string ShowShareThread(this SiteUrls siteUrls, int threadID)
        {
            return SPBUrlHelper.RouteUrl("Channel_Share_ShowThread", new RouteValueDictionary() { { "threadID", threadID } });
        }
        /// <summary>
        /// 获取站点站外分享显示的URL
        /// </summary>
        /// <returns></returns>
        public static string ShowShareThread(this SiteUrls siteUrls, int threadID, int childCommentID)
        {
            return ShowShareThread(siteUrls, threadID) + "#" + childCommentID;
        }
        /// <summary>
        /// 根据站点标签列表显示分享
        /// </summary>
        public static string ListShareThreadsBySiteTag(this SiteUrls siteUrls, string tagName)
        {
            return SPBUrlHelper.RouteUrl("Channel_Share_ListThreadsByTag", new RouteValueDictionary { { "tagName", WebUtils.UrlEncode(tagName) } });
        }
        /// <summary>
        /// 获取分享分享显示的URL
        /// </summary>
        /// <returns></returns>
        public static string ShowUserShareThread(this SiteUrls siteUrls, string userDomainName, int userThreadID)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Share_ShowUserThread", new RouteValueDictionary() { { "UserDomainName", userDomainName }, { "userThreadID", userThreadID } });
        }

        /// <summary>
        /// 获取分享分享显示的URL
        /// </summary>
        /// <returns></returns>
        public static string ShowUserShareThread(this SiteUrls siteUrls, string userDomainName, UserShareThread userShareThread)
        {
            if (userShareThread == null || userShareThread.SiteShareThread == null)
                return string.Empty;

            if (userShareThread.SiteShareThread.ApplicationID > 0)
                return userShareThread.SiteShareThread.URL;
            else
                return SPBUrlHelper.RouteUrl("UserDomain_Share_ShowUserThread", new RouteValueDictionary() { { "UserDomainName", userDomainName }, { "userThreadID", userShareThread.UserThreadID } });
        }

        /// <summary>
        /// 获取分享显示的URL
        /// </summary>
        /// <returns></returns>
        public static string ShowUserShareThread(this SiteUrls siteUrls, string userDomainName, int userThreadID, int childCommentID)
        {
            return ShowUserShareThread(siteUrls, userDomainName, userThreadID) + "#" + childCommentID;
        }
        /// <summary>
        /// 分享插件对话框
        /// </summary>
        /// <param name="threadID">站点分享ID</param>
        public static string ShareDialog(this SiteUrls siteUrls)
        {
            return SPBUrlHelper.RouteUrl("Channel_Share_Common", new RouteValueDictionary { { "action", "ShareDialog" } });
        }
        /// <summary>
        /// 分享模式框
        /// </summary>
        /// <param name="siteUrls"></param>
        /// <param name="threadID"></param>
        /// <returns></returns>
        public static string ShareInModal(this SiteUrls siteUrls, int threadID)
        {
            return SPBUrlHelper.RouteUrl("Channel_Share_Common", new RouteValueDictionary { { "action", "Control_ShareInModal" }, { "threadID", threadID } });
        }
        /// <summary>
        /// 分享模式框
        /// </summary>
        /// <param name="siteUrls"></param>
        /// <param name="threadID"></param>
        /// <returns></returns>
        public static string ShareInModal(this SiteUrls siteUrls, int threadID, bool allowToClub)
        {
            return SPBUrlHelper.RouteUrl("Channel_Share_Common", new RouteValueDictionary { { "action", "Control_ShareInModal" }, { "threadID", threadID }, { "allowToClub", allowToClub } });
        }
        /// <summary>
        /// 分享模式框
        /// </summary>
        /// <param name="siteUrls"></param>
        /// <param name="allowToClub"></param>
        /// <param name="url"></param>
        /// <param name="subject"></param>
        /// <param name="body"></param>
        /// <param name="thumbnailUrl"></param>
        /// <param name="applicationID"></param>
        /// <param name="contentUserID"></param>
        /// <param name="contentAuthor"></param>
        /// <returns></returns>
        public static string ShareInModal(this SiteUrls siteUrls, bool allowToClub, string url, string subject, string body, string thumbnailUrl, int applicationID, int contentUserID, string contentAuthor)
        {
            return SPBUrlHelper.RouteUrl("Channel_Share_Common", new RouteValueDictionary() { { "action", "Control_ShareInModal" }, { "allowToClub", allowToClub }, { "url", WebUtils.UrlEncode(url) }, { "subject", WebUtils.UrlEncode(subject) }, { "body", WebUtils.UrlEncode(body) }, { "thumbnailUrl", WebUtils.UrlEncode(thumbnailUrl) }, { "applicationID", applicationID }, { "contentUserID", contentUserID }, { "contentAuthor", WebUtils.UrlEncode(contentAuthor) } });
        }
        /// <summary>
        /// 分享插件
        /// </summary>
        /// <param name="threadID">站点分享ID</param>
        public static string ShareDialog(this SiteUrls siteUrls, int threadID)
        {
            return SPBUrlHelper.RouteUrl("Channel_Share_Common", new RouteValueDictionary { { "action", "ShareDialog" }, { "threadID", threadID } });
        }
        /// <summary>
        /// 分享插件
        /// </summary>
        /// <param name="url">地址</param>
        /// <param name="subject">标题</param>
        /// <param name="body">内容摘要</param>
        /// <param name="thumbnailUrl">缩略图地址</param>
        /// <param name="applicationID">应用ID</param>
        /// <param name="contentAuthor">内容作者ID</param>
        /// <param name="contentAuthor">内容作者</param>
        public static string ShareDialog(this SiteUrls siteUrls, string url, string subject, string body, string thumbnailUrl, int applicationID, int contentUserID, string contentAuthor)
        {
            return SPBUrlHelper.RouteUrl("Channel_Share_Common", new RouteValueDictionary() { { "action", "ShareDialog" }, { "url", WebUtils.UrlEncode(url) }, { "subject", WebUtils.UrlEncode(subject) }, { "body", WebUtils.UrlEncode(body) }, { "thumbnailUrl", WebUtils.UrlEncode(thumbnailUrl) }, { "applicationID", applicationID }, { "contentUserID", contentUserID }, { "contentAuthor", WebUtils.UrlEncode(contentAuthor) } });
        }
        /// <summary>
        /// 根据用户标签列表显示分享
        /// </summary>
        public static string ListUserShareThreadsByUserTag(this SiteUrls siteUrls, string userDomainName, string tagName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Share_ListUserThreadsByTag", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "tagName", WebUtils.UrlEncode(tagName) } });
        }
    }
}