﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Vote;
using SpaceBuilder.Club;

namespace SpaceBuilder.Vote.Modules
{
    public class AutoInstallVoteApplicationOfClub : IClubModule
    {
        #region IClubModule 成员

        public void Init(ClubEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterClubChange += new ClubEventHandler(em_AfterClubChange);
        }

        void em_AfterClubChange(Club.Club club, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (club != null && e.State == ObjectState.Create)
            {
                if (VoteConfiguration.Instance().EnableAutoCreate)
                {
                    Applications.InstallApplication(PresentAreaIDs.Instance().ClubDomain(), club.ClubID, ApplicationIDs.Instance().Vote());
                }
            }
        }

        #endregion
    }
}
